class Rock {

  //declare necessary PVectors
  
  PVector position = new PVector();
  PVector oldPosition = new PVector();
  PVector velocity = new PVector();

  //declare necessary variables
  
  float rockLeft, rockRight, rockTop, rockBottom;
  float rockDamage;
  int explosionCounter;
  boolean rockBoomBase = false;
  boolean rockBoomShield = false;

  Rock() {
    init();
  }

  void init() {
    //set initial rock values.
    position.x = random(0, 800);
    position.y = 0 - random(200);
    velocity.y = random(.5, 2) + difficultyTimer / 600;
  }

  void update() {
    //checks for game over
    if (gameOver == false) {
      //move the rock downwards
      position.add(velocity);

      //reconfirms the rock's position for collisions
      rockLeft = position.x;
      rockTop = position.y;
      rockRight = position.x + 50;
      rockBottom = position.y + 50;

      //checks to see if the rock has impacted the base
      if (rockBottom > baseTop) {
        rockBoomBase = true;
        rockBoomShield = false;
        explosionCounter = 0;
        rockDamage = 2 + velocity.y;
        oldPosition.x = position.x + 25;
        oldPosition.y = position.y + 50;
        init();
        baseHealth = baseHealth - rockDamage;
      }

      //checks to see if the rock has impacted the shield
      if (rockRight > shieldLeft && rockLeft < shieldRight && rockBottom > shieldTop && rockTop < shieldBottom) {
        rockBoomShield = true;
        rockBoomBase = false;
        score = score + 5 * velocity.y;
        explosionCounter = 0;
        oldPosition.x = position.x + 25;
        oldPosition.y = position.y + 50;
        init();
      }
    }
  }

  void display() {
    
    //draws the rock
    
    noStroke();
    ellipseMode(CORNERS);
    fill(147, 83, 0, 255);
    ellipse(position.x, position.y, position.x + 50, position.y + 50);
    triangle(position.x, position.y - 10, position.x + 35, position.y + 10, position.x, position.y + 20);
    triangle(position.x + 10, position.y + 15, position.x + 35, position.y, position.x + 60, position.y + 15);
    triangle(position.x + 9, position.y + 15, position.x + 34, position.y + 30, position.x + 59, position.y + 15);
    triangle(position.x, position.y + 25, position.x + 20, position.y + 55, position.x + 50, position.y + 25);
    triangle(position.x, position.y + 25, position.x - 5, position.y + 55, position.x + 30, position.y + 50);
    
    //checks for base explosion and draws it
    
    if (rockBoomBase == true) {
      fill(255, 150, 0, 255 - explosionCounter * 5);
      ellipseMode(CENTER);
      ellipse(oldPosition.x, oldPosition.y, 15 + explosionCounter * 2, 15 + explosionCounter * 2);
      explosionCounter++;
    }
    
    //checks for shield break and draws it
    
    if (rockBoomShield == true) {
      fill(147, 83, 0, 255 - explosionCounter * 5);
      ellipseMode(CENTER);
      ellipse(oldPosition.x, oldPosition.y, 5 + explosionCounter * 2, 5 + explosionCounter * 2);
      explosionCounter++;
    }
  }
}