class Tank {

  //declares necessary pVectors
  PVector position = new PVector();
  PVector velocity = new PVector();

  //declares animation variables
  int glowVariation = 200;
  int variationIncrement = 5;

  //declare shield position

  float shieldPositionLeft;
  float shieldPositionRight;
  float shieldPositionTop;
  float shieldPositionBottom;

  Tank() {
    init();
  }

  void init() {
    //sets tank starting point
    position.x = 400;
    position.y = 500;
    velocity.x = 0;
  }

  void update() {

    //checks for game over

    if (gameOver == false) {

      //update the shield position

      shieldPositionLeft = position.x - 50;
      shieldPositionRight = position.x + 50;
      shieldPositionTop = position.y - 70;
      shieldPositionBottom = position.y - 60;

      //updates the shield collision
      shieldLeft = shieldPositionLeft;
      shieldRight = shieldPositionRight;
      shieldTop = shieldPositionTop;
      shieldBottom = shieldPositionBottom;

      //alter the tank's velocity, increasing and decreasing speed with button presses, as opposed to basic left button moves left and right button moves right
      if (leftPressed == true) {
        velocity.x--;
      }
      if (rightPressed == true) {
        velocity.x++;
      }

      if (velocity.x > 10) {
        velocity.x = 10;
      }
      if (velocity.x < -10) {
        velocity.x = -10;
      }

      position.add(velocity);
      if (position.x > 800) {
        position.x = 800;
      }
      if (position.x < 0) {
        position.x = 0;
      }
    }
  }

  void display() {

    //change the glow on the glowing parts

    glowVariation = glowVariation + variationIncrement;
    if (glowVariation > 200) {
      variationIncrement = -5;
    }
    if (glowVariation < 50) {
      variationIncrement = 5;
    }

    //display the tank

    ellipseMode(CENTER);
    fill(0, 255, 255);
    ellipse(position.x, position.y - 36, 32, 32);
    fill(255, 255, 255, 0 + glowVariation);
    ellipse(position.x, position.y - 36, 36, 36);
    rectMode(CENTER);
    fill(105, 160, 15, 255);
    rect(position.x, position.y - 25, 36, 36);
    ellipseMode(CENTER);
    fill(110, 40, 35, 255);
    ellipse(position.x - 18, position.y - 7, 20, 20);
    ellipse(position.x + 18, position.y - 7, 20, 20);

    //display the shield near the tank itself
    rectMode(CORNERS);
    fill(0, 255, 255);
    rect(shieldPositionLeft, shieldPositionTop, shieldPositionRight, shieldPositionBottom);
    fill(255, 255, 255, 0 + glowVariation);
    rect(shieldPositionLeft - 2, shieldPositionTop - 2, shieldPositionRight + 2, shieldPositionBottom + 2);
  }
}