/*
Shield Defense Base: By Michael Downey

A small little game where you control a slippery moving tank that
generates a shield above it, and try to defend the base beneath
you against a meteor shower. As the game goes on, the sky gets
darker, the meteors speed up, and the impact deals more damage.
However, faster meteors give a higher score. When the base is
destroyed, your final score is displayed.
*/


//declare all objects

int numberOfRocks = 5;
int numberOfStars = 20;
Rock[] meteorShower= new Rock[numberOfRocks];
Base base;
//Collision[] explosions= new Collision[numberOfRocks];
Star[] stars= new Star[numberOfStars];
Tank tank;
Timer timer;

//declare all global variables

float difficultyTimer;
float score = 0;
int scoreDisplay = 0;
int finalScore = 0;

//declare all values related to the base globally to ensure that other classes can use them

float baseLeft = 0;
float baseTop = 500; 
float baseRight = 800;
float baseBottom = 600;
float baseHealth = 500; //health of the military base

//declare shield collision values globally to ensure that other classes

float shieldLeft;
float shieldTop; 
float shieldRight;
float shieldBottom;

//declare booleans for movement and game over

boolean leftPressed = false;
boolean rightPressed = false;
boolean gameOver = false;

void setup() {
  //set up the window size, the frame rate, and the main background color
  size(800, 600);
  frameRate(60);
  rectMode(CORNERS);
  noStroke();

  //Activates the game objects
  createMeteorShower();
  //createExplosions();
  createStars();
  base=new Base();
  tank=new Tank();
  timer=new Timer();
}

void createMeteorShower() {
  for (int i=0; i<meteorShower.length; i++) {
    meteorShower[i]=new Rock();
  }
}

//explosions were going to be a seperate class, but creating them in the same class as the meteors proved mroe efficient

/*void createExplosions() {
 for (int i=0; i<explosions.length; i++) {
 explosions[i]=new Collision();
 }
 }*/

void createStars() {
  for (int i=0; i<stars.length; i++) {
    stars[i]=new Star();
  }
}

void draw() {

  //updates all of the major game objects
  timer.update();
  for (int i=0; i<stars.length; i++) {
    stars[i].update();
  }
  for (int i=0; i<meteorShower.length; i++) {
    meteorShower[i].update();
  }
  tank.update();

  //prevents the base health from going below zero
  if (baseHealth < 0) {
    baseHealth = 0;
  }

  //draw the background
  background(0, 0, 30);
  for (int i=0; i<stars.length; i++) {
    stars[i].display();
  }
  fill(0, 200, 255, 250 - difficultyTimer / 100); //The brightness of the background is an indicator of the meteor shower's average speed
  noStroke();
  rectMode(CORNERS);
  rect(0, 0, 800, 600);

  //display major game objects
  base.display();
  tank.display();
  for (int i=0; i<meteorShower.length; i++) {
    meteorShower[i].display();
  }

  //display the score
  fill(0 + difficultyTimer / 100);
  textSize(32);
  scoreDisplay = int(score);
  text("Score:" + scoreDisplay, 0, 32);

  //Activates game over and reveals final score
  if (baseHealth <= 0) {
    fill(0);
    gameOver = true;
    rectMode(CORNERS);
    rect(0, 0, 800, 600);
    fill(255);
    textSize(64);
    finalScore = int(score);
    text("GAME OVER! Score:" + finalScore, 25, 300);
  }
}

void keyPressed() {
  //detect if the player has pressed left or right
  switch(key) {
  case 'a':
    leftPressed = true;
    break;
  case 'd':
    rightPressed = true;
    break;
  }
}

void keyReleased() {
  //detect if the player has pressed left or right
  switch(key) {
  case 'a':
    leftPressed = false;
    break;
  case 'd':
    rightPressed = false;
    break;
  }
}