public class Floor {

  // Big Spikes
  private Spike[] bigSpikes = new Spike[20];

  // Small Spikes
  private Spike[] smallSpikes = new Spike[100];

  public void generateBigSpikes() {
    // Generates the big spikes in the array
    for (int i = 0; i < bigSpikes.length; i++) 
      bigSpikes[i] = new Spike();
    
    // Generates the big spike conditions for every spike in the array
    for (int i = 0; i < bigSpikes.length; i++) {
      bigSpikes[i].spikeX = random(0, width);
      bigSpikes[i].gradStart = color(255, 0, 0);
      bigSpikes[i].gradEnd = color(60, 0, 0);
      bigSpikes[i].spikeY = 600;
      bigSpikes[i].spikeSize = random(35, 60);
      bigSpikes[i].spikeHalfSize = bigSpikes[i].spikeSize / 2;
    }
  }

  public void generateSmallSpikes() {
    // Generates the small spikes in the array
    for (int i = 0; i < smallSpikes.length; i++) 
      smallSpikes[i] = new Spike();

    // Generates the small spike conditions for every spike in the array
    for (int i = 0; i < smallSpikes.length; i++) {
      smallSpikes[i].spikeX = random(0, width);
      smallSpikes[i].gradStart = color(20);
      smallSpikes[i].gradEnd = color(5);
      smallSpikes[i].spikeY = 600;
      smallSpikes[i].spikeSize = random(10, 25);
      smallSpikes[i].spikeHalfSize = smallSpikes[i].spikeSize / 1.5;
    }
  }

  // Draw the floor
  public void drawFloor() {
    // Loop through the array and draw the spikes randomly
    for (int i = 0; i < bigSpikes.length; i++) 
      bigSpikes[i].display();

    for (int i = 0; i < smallSpikes.length; i++) 
      smallSpikes[i].display();

    // Floor line
    pushMatrix();
    beginShape(); 
    fill(30);
    vertex(0, 535);

    fill(30);
    vertex(0, 536);

    fill(100);
    vertex(150, 536);

    fill(100);
    vertex(650, 536);

    fill(30);
    vertex(800, 536);

    fill(30);
    vertex(800, 535);

    fill(100);
    vertex(150, 535);

    fill(100);
    vertex(650, 535);  
    endShape();
    popMatrix();
  }
}