// Keyboard keyCode values (from processing wiki)
int KEY_A = 65;
int KEY_D = 68;
int KEY_W = 87;
int KEY_S = 83;

class Keyboard {
    private boolean states[] = new boolean[256];

    public Keyboard() {
        for (int i = 0; i < states.length; i++)
            states[i] = false;
    }

    public void onPressed(int _keyCode) {
        //assert(_keyCode > 0 && _keyCode < states.length);
        states[_keyCode] = true;
    }

    public boolean isKeyDown(int _keyCode) {
        //assert(_keyCode > 0 && _keyCode < states.length);
        return states[_keyCode];
    }

    public void onReleased(int _keyCode) {
        //assert(_keyCode > 0 && _keyCode < states.length);
        states[_keyCode] = false;
    }

    public boolean isKeyUp(int _keyCode) {
        //assert(_keyCode > 0 && _keyCode < states.length);
        return !states[_keyCode];
    }
}