class Particle {
    PVector location;
    PVector velocity;
    PVector acceleration;

    float particleSize;
    color particleStroke;
    color particleFill;
    float w;
    float h;

    float fadeStroke = 100;
    float fadeFill = 150;

    // Update location of the particle and fade the floor particles
    void updateParticles() {
        if (location.y <= height) {
            fadeStroke -= 10;
            fadeFill -= 5;
        }
        
        velocity.add(acceleration);
        location.add(velocity);
        velocity.limit(3.5);
    }

    public void display() {
        drawParticle(particleSize, particleStroke, particleFill, location.x, location.y, w, h);
    }

    // Draw the particle
    void drawParticle(float sW, color s, color f, float x, float y, float w, float h) {
        strokeWeight(sW);
        stroke(s);
        fill(f);
        ellipse(x, y, w, h);
    }
}