class ParticleSystem {

    // Particles that are randomly moving around in the background
    // of the scene
    Particle[] psRandom = new Particle[20];

    // Particles that are on the floor
    Particle[] psFloor = new Particle[40];

    // Particles that follow the player
    Particle[] psPlayer = new Particle[20];

    float offset;

    // Generates the particles conditions for every particle in the array
    void generateParticles(PVector playerPos) {
        // Initialize random particles
        for (int i = 0; i < psRandom.length; i++) {
            psRandom[i] = new Particle();
            psRandom[i].location = new PVector(random(100, 500), height);
            psRandom[i].particleFill = color(181, 14, 14, 50);
            psRandom[i].acceleration = new PVector(0, 0);
            psRandom[i].velocity = new PVector(0, 0);
        }

        // Initialize particles on the floor
        for (int i = 0; i < psFloor.length; i++) {
            psFloor[i] = new Particle();
            psFloor[i].location = new PVector(random(0, width), random(height, 700));
            psFloor[i].particleSize = 2;
            psFloor[i].w = 5;
            psFloor[i].h = 6;
            psFloor[i].acceleration = new PVector(0, random(-0.01, -0.02));
            psFloor[i].velocity = new PVector(0, -2);
        }

        // Initialize particles following player
        for (int i = 0; i < psPlayer.length; i++) {
            psPlayer[i] = new Particle();
            psPlayer[i].location = new PVector(random(0, 50), playerPos.y + random(0, 50));
            psPlayer[i].particleSize = 1;
            psPlayer[i].w = 5;
            psPlayer[i].h = 6;
            psPlayer[i].acceleration = new PVector(0, random(-0.1, -0.2));
            psPlayer[i].velocity = new PVector(0, -2);
        }
    }

    // Generates the particles conditions that need to
    // be in draw for every particle in the array
    void drawParticles() {
        for (int i = 0; i < psRandom.length; i++) {
            psRandom[i].acceleration = PVector.random2D();
            psRandom[i].particleSize = sin(frameCount * 0.7) * 5;
            psRandom[i].particleStroke = color(255, 0, 0, sin(frameCount * 0.2) * 40);
            psRandom[i].w = 8 + sin(frameCount * 0.06) * 3;
            psRandom[i].h = 8 + sin(frameCount * 0.06) * 3;
            psRandom[i].updateParticles();
            psRandom[i].display();
        }

        for (int i = 0; i < psFloor.length; i++) {
            psFloor[i].particleFill = color(10, psFloor[i].fadeFill);
            psFloor[i].particleStroke = color(255, 0, 0, psFloor[i].fadeStroke);
            psFloor[i].updateParticles();
            psFloor[i].display();
        }

        for (int i = 0; i < psPlayer.length; i++) {
            psPlayer[i].particleFill = color(10, psPlayer[i].fadeFill);
            psPlayer[i].particleStroke = color(180, 133, 0, psPlayer[i].fadeStroke);
            psPlayer[i].updateParticles();
            offset = psPlayer[i].location.x;
            psPlayer[i].location.x = player.location.x + offset;
            psPlayer[i].display();
            psPlayer[i].location.x = offset;
        }
    }

    void constrainParticle(PVector playerPos) {
        // Locks random prticles within the screen
        for (int i = 0; i < psRandom.length; i++) {
            if (psRandom[i].location.x >= width)
                psRandom[i].location.x = -8;

            if (psRandom[i].location.x <= -8)
                psRandom[i].location.x = width;

            if (psRandom[i].location.y >= height)
                psRandom[i].location.y = -8;

            if (psRandom[i].location.y <= -8)
                psRandom[i].location.y = height;
        }

        // Reset the floor particles when they hit the ground
        for (int i = 0; i < psFloor.length; i++) {
            if (psFloor[i].location.y <= 533 + psFloor[i].h) {
                psFloor[i].location.y = height;
                psFloor[i].fadeStroke = 100;
                psFloor[i].fadeFill = 150;
                psFloor[i].velocity.y = -2;
            }
        } 
        
        // Reset the player particles depending on their distance away from the player
        for (int i = 0; i < psPlayer.length; i++) {
            float distY = abs(playerPos.y - psPlayer[i].location.y);

            if (distY >= 100) {
                psPlayer[i].location.y = playerPos.y + random(0, 50);
                psPlayer[i].fadeStroke = 100;
                psPlayer[i].fadeFill = 150;
                psPlayer[i].velocity.y = -2;
            }
        }
    }
}