class Platform {

    PVector location,
            velocity,
            acceleration;

    float endPos; // End position of platform

    Platform() {
        velocity = new PVector(2, 2);
        acceleration = new PVector(0.06, 0.06);

    }

    void drawPlatform() {
        // Platform
        noStroke();
        pushMatrix();
        beginShape();
        // Top left
        fill(0);
        vertex(location.x, location.y); 
        // Top right
        fill(0);
        vertex(location.x + 70, location.y);
        // Bot right
        fill(180, 18, 93, 70);
        vertex(location.x + 70, location.y + 25);
        // Bot left
        fill(180, 18, 93, 70);
        vertex(location.x, location.y + 25);
        endShape();
        popMatrix();

        // Gives a stroke to the platform
        strokeWeight(1);
        stroke(255);
        noFill();
        rect(location.x - 1, location.y - 1, 72, 27);

        // Handle
        stroke(5);
        strokeWeight(3);
        line(location.x + 35, location.y + 28, location.x + 35, location.y + 45);

        // Blinking light
        fill(180, 18, 93, 70);
        stroke(30);
        strokeWeight(1);
        ellipseMode(CENTER);
        ellipse(location.x + 35, location.y + 45, sin(frameCount * 0.06) * 20, sin(frameCount * 0.06) * 20);
    }

    // Move the platform up on start up
    void movePlatform() {
        location.y -= velocity.y;
        velocity.y += acceleration.y;

        if (location.y <= endPos) {
            velocity.y = 0;
            acceleration.y = 0;
        }
    }

    // Is the player colliding with a platform
    public boolean collides() {
        if (player.location.y < location.y + 25 && player.size + player.location.y > location.y &&
            player.location.x < location.x + 70 && player.location.x + player.size > location.x) {
            return true;
        }

        return false;
    }
}