class Player {

    PVector location,
            velocity,
            acceleration; 

    float ground;

    float gravity,
          size;

    float playerSpeed,
          jumpSpeed,
          jumpGravityReduction;

    boolean jumping;

    Player() {
        size = 50;
        ground = 533;
        gravity = 4;

        playerSpeed = 2.5;
        jumpSpeed = 19;
        jumpGravityReduction = 0.25;

        jumping = false;

        location = new PVector(width / 2, ground - size);
        velocity = new PVector(0, 0);
        acceleration = new PVector(0, 0);
    }

    void runInput() {
        // Recalculate input velocity
        acceleration.x = 0;
        acceleration.y = 0;

        if (keyboard.isKeyDown(KEY_A)) {
            acceleration.x -= 8;
        } else if (keyboard.isKeyDown(KEY_D)) {
            acceleration.x += 8;
        }

        if (keyboard.isKeyDown(KEY_W) && !jumping) {
            jumping = true;
            velocity.y = -jumpSpeed;
        } 
    }

    void move() {
        // Apply gravity
        if (velocity.y < gravity) {
            float actualGravity = gravity;

            if (jumping)
                actualGravity *= jumpGravityReduction;

            velocity.y += actualGravity;

            // Clamp gravity
            if (velocity.y > gravity) 
                velocity.y = gravity;
        }

        // Check if the movement is making us collide with something
        boolean currentlyColliding = false;

        for (int i = 0; i < platforms.platforms.length; i++) {
            Platform p = platforms.platforms[i];
            boolean doesCollide = p.collides();

            if (doesCollide) {
                currentlyColliding = true;
                break;
            }
        }

        // Does moving down make us hit something
        float velY = velocity.y + acceleration.y;
        location.y += velY;
        boolean collidingBottom = false;

        for (int i = 0; i < platforms.platforms.length; i++) {
            Platform p = platforms.platforms[i];
            boolean doesCollide = p.collides();

            if (!currentlyColliding && doesCollide) {
                // Make sure the player doesn't go through the object
                collidingBottom = velY < 0;

                if (!collidingBottom) {
                    location.y = p.location.y - size - 1;
                    jumping = false; // Reset jumping because we're hitting a platform
                }
                break;
            }
        }

        float velX = velocity.x + acceleration.x;
        location.x += velX;

        for (int i = 0; i < platforms.platforms.length; i++) {
            Platform p = platforms.platforms[i];
            boolean doesCollide = p.collides();

            if (!currentlyColliding && doesCollide && !collidingBottom) {
                boolean collidingLeft = velX > 0;

                if (collidingLeft) {
                    location.x = p.location.x - size - 1;
                } else  {
                    location.x = p.location.x + 70 + 1;
                }
                break;
            }
        }
    }

    void drawPlayer() {
        stroke(255, 132, 0);
        strokeWeight(1);
        fill(50);
        rect(location.x, location.y, size, size);
        noStroke();
        fill(255, 132, 0, 100);
        rect(location.x + 10, location.y + 10, size - 20, size - 20);
        fill(50);
        rect(location.x + 15, location.y + 15, size - 30, size - 30);
    }

    // Constrain the player to the screen
    void constrainPlayer() {
        if (location.x >= width) {
            location.x = 0 - size + 1;
        }

        if (location.x <= 0 - size) {
            location.x = width;
        }

        if (location.y + (velocity.y + acceleration.y) > ground - size) {
            location.y = ground - size;
            jumping = false;
        }
    }
}