class SetPlatforms {

  Platform[] platforms = new Platform[7];

  public void generatePlatforms() {    
    // Sets random positions for the platforms
    for (int i = 0; i < platforms.length; i++) {
      platforms[i] = new Platform();
      platforms[i].endPos = random(60, 450);
      platforms[i].location = new PVector(random(10, width - 80), height + 1);
    }

    // Ensure that each platform is spaced out from all other platforms
    for (int i = 0; i < platforms.length; i++) {
      boolean finished = false;
      int attempts = 0; // safety to make sure the loop doesn't run infinitely

      while (!finished) {
        attempts++;
        finished = true;

        for (int j = 0; j < platforms.length; j++) {
          // don't try and space the platform out from itself
          if (j == i) 
            continue;

          float distX = abs(platforms[j].location.x - platforms[i].location.x);
          float distY = abs(platforms[j].location.y - platforms[i].location.y);

          if (distY < 45 && distX < 75) {
            // platform is too close; re-generate, try again.
            finished = false;
            platforms[i].location = new PVector(random(10, width - 80), height + 1);

            // break out of the for loop and start checking over again
            break;
          }
        }
        // Perhaps there's a better way of doing this?
        // Preventing an infinite loop
        if (attempts > 500000) {
          //println("Quite unlucky!");
          break;
        }
      }
    }
  }

  void drawPlatforms() {
    // Draw and update the platforms in the array
    for (int i = 0; i < platforms.length; i++) {
      platforms[i].movePlatform();
      platforms[i].drawPlatform();
    }
  }
}