public class Spike {
  public color gradStart, 
    gradEnd;

  public float spikeX, 
    spikeY, 
    spikeSize, 
    spikeHalfSize;

  public void display() {
    drawGradientSpike(spikeX, spikeY, spikeX + (spikeHalfSize / 2), spikeY - spikeSize, 
      spikeX + spikeHalfSize, spikeY, gradStart, gradEnd);
  }

  // Draws the gradient spike
  void drawGradientSpike(float x1, float y1, float x2, float y2, float x3, float y3, color color1, color color2) {
    noStroke();
    pushMatrix();
    beginShape();
    // top of triangle
    fill(color1);
    vertex(x2, y2);
    // bottom left
    fill(color2);
    vertex(x1, y1);
    // bottom right
    vertex(x3, y3);
    endShape();
    popMatrix();
  }
}