///////////////////////////
//    Jumping Square     //
//  Object Oriented toy  //
// By: Nicolas Olivieri  //
///////////////////////////

// No objective, just jump around the screen
// and enjoy the pretty lights that run away from you!
//
// W = Jump
// A = Left
// D = Right

Floor floor;
Background gradBG;
Player player;
SetPlatforms platforms;
Particle p;
ParticleSystem ps;
Keyboard keyboard = new Keyboard();

void setup() {
    // Initialize screen
    size(800, 600, P2D);

    // Create the background
    gradBG = new Background();

    // Create the floor
    floor = new Floor();

    // Create the platforms
    platforms = new SetPlatforms();

    // Create the player
    player = new Player();

    // Create the particle system
    ps = new ParticleSystem();

    // Generate the spikes
    floor.generateBigSpikes();
    floor.generateSmallSpikes();

    // Generate the platforms
    platforms.generatePlatforms();

    // Generate the particles
    ps.generateParticles(player.location);
}

void draw() {
    frameRate(60);

    // Make sure particles don't go off the screen
    ps.constrainParticle(player.location);
    MPAFP();
    // Move the player
    player.runInput();
    player.move();
    player.constrainPlayer();

    gradBG.drawBG();
    ps.drawParticles();
    floor.drawFloor();
    platforms.drawPlatforms();
    player.drawPlayer();
}

// Move particles away from player
void MPAFP() {
    float playerCenterX = player.location.x + player.size / 2;
    float playerCenterY = player.location.y + player.size / 2;

    for (int i = 0; i < ps.psRandom.length; i++) {
        float distX = abs(playerCenterX - ps.psRandom[i].location.x);
        float distY = abs(playerCenterY - ps.psRandom[i].location.y);
  
        if (distX < 50 && distY < 50) {
            ps.psRandom[i].velocity.x = -player.velocity.x * 1.5;
            ps.psRandom[i].velocity.y = player.velocity.y * 1.5;
        }           
    }
}

// Needed to keep track of multiple keys being pressed at the same time
void keyPressed() {
    keyboard.onPressed(keyCode);
}

void keyReleased() {
    keyboard.onReleased(keyCode);
}
