//Title: Dowsing Pendulum Toy
//Creator: Nikki Arezza
//Description: 
//- The user can move the mouse around the scene to essentially "dowse" the area
//- Once near the general area of the secret, the Pendulum will begin to glow
//- If the correct location is clicked, it causes the scene to go dark and begin to rain

//CONSTRUCT OBJECTS
Pendulum dowse = new Pendulum();
Fireflies fly = new Fireflies();


//CONSTRUCT ARRAYS
int numberOfBugs = 6;
Fireflies[] clusterOfBugs = new Fireflies[numberOfBugs];

int numberOfDrops = 30;
Rain[] dropAmount = new Rain[numberOfDrops];

//Set secret initially to false
boolean secret;

void setup() {
  size(800, 600);
  noCursor();
  fireFlyGroup();
  rainGroup();
}
//end of setup() routine


void draw() {

  //UPDATE//

  //updates fireflies
  for (int i = 0; i < clusterOfBugs.length; i++) {
    clusterOfBugs[i].update();
  }
  //end of for loop

  //updates rain drops
  if (secret == true) {
    for (int i = 0; i < dropAmount.length; i++) {
      dropAmount[i].update();
    }
    //end of for loop
  }
  //end of if statement

  //DRAW//

  environment();
  dowse.drawPendulum();
  mysteryPoint();

  //draws fireflies
  for (int i = 0; i < clusterOfBugs.length; i++) {
    clusterOfBugs[i].display();
  }
  //end of for loop

  //draws raindrops
  if (secret == true) {
    for (int i = 0; i < dropAmount.length; i++) {
      dropAmount[i].display();
    }
    //end of for loop
  }
  //end of if statement
}
//end of draw() routine


void environment() {
  background(71, 68, 108);

  //MOON
  noStroke();
  fill(244, 250, 184);
  ellipse(200, 100, 50, 50);
  fill(71, 68, 108);
  ellipse(210, 100, 40, 40);

  //Moonglow
  fill(255, 255, 201, 50);
  ellipse(200, 100, 120, 90);
  fill(255, 201, 201, 30);
  ellipse(200, 100, 200, 150);

  //GROUND
  noStroke();
  fill(45, 57, 70);
  rect(0, 270, 800, 600);

  //POND
  fill(90, 140, 193);
  ellipse(200, 360, 300, 60);
  ellipse(480, 380, 400, 60);
  ellipse(360, 410, 300, 60);

  //TREES
  fill(90, 12, 17);
  rectMode(CORNERS);
  rect(760, 0, 800, 450);
  rect(10, 0, 40, 350);
  rect(70, 0, 95, 330);
  rect(700, 0, 720, 370);
  rect(650, 0, 680, 410);
  rect(120, 0, 135, 300);
  rect(300, 0, 310, 290);
  rect(370, 0, 380, 285);
  rect(590, 0, 610, 300);
  rect(520, 0, 540, 330);
  rect(460, 0, 470, 290);

  //BACKGROUND ROCKS
  fill(45, 65, 70);
  quad(0, 220, 10, 200, 10, 270, 0, 270);
  quad(40, 220, 60, 220, 60, 270, 40, 270);
  quad(60, 220, 70, 240, 70, 270, 60, 270);
  quad(95, 250, 120, 260, 120, 270, 95, 270);
  triangle(150, 270, 190, 250, 190, 270);
  quad(190, 250, 230, 240, 230, 270, 190, 270);
  triangle(230, 240, 280, 270, 230, 270);

  //FOREGROUND ROCKS
  noStroke();
  fill(0);

  //Left Rock
  quad(0, 300, 30, 310, 30, 600, 0, 600);
  quad(30, 310, 50, 305, 50, 600, 30, 600);
  quad(50, 305, 60, 370, 60, 600, 50, 600);
  quad(60, 370, 80, 390, 80, 600, 60, 600);
  quad(80, 390, 100, 450, 100, 600, 80, 600);
  quad(100, 450, 120, 460, 120, 600, 100, 600);
  quad(120, 460, 150, 500, 150, 600, 120, 600);
  quad(150, 500, 250, 520, 250, 600, 150, 600);
  quad(250, 520, 270, 540, 270, 600, 250, 600);
  triangle(270, 540, 270, 560, 270, 600);
  quad(270, 560, 300, 570, 300, 600, 270, 600);
  triangle(300, 570, 320, 600, 300, 600);

  //Right Rock
  quad(800, 430, 750, 400, 750, 600, 800, 600);
  quad(750, 400, 700, 420, 700, 600, 750, 600);
  quad(700, 420, 680, 410, 680, 600, 700, 600);
  quad(680, 410, 650, 450, 650, 600, 680, 600);
  quad(650, 450, 640, 470, 640, 600, 650, 600);
  quad(640, 470, 600, 500, 600, 600, 640, 600);
  quad(600, 500, 580, 530, 580, 600, 600, 600);
  quad(580, 530, 480, 580, 480, 600, 580, 600);
  triangle(480, 580, 470, 600, 480, 600);
}
//end of environment() routine

void fireFlyGroup() {
  for (int i= 0; i < clusterOfBugs.length; i++) {
    clusterOfBugs[i] = new Fireflies();
  }
  //end of for loop
}
//end of fireFlyGroup() routine

void rainGroup() {
  for (int i = 0; i < dropAmount.length; i++) {
    dropAmount[i] = new Rain();
  }
  //end of for loop
}
//end of rainGroup() routine

void mysteryPoint() {
//Creates range for glow indicator
  if (mouseX > 500 && mouseY > 250 && mouseX < 700 && mouseY < 450) {
    dowse.glowIndicator();
  }
  //end of if statement
}
//end of mysteryPoint() routine

void mousePressed() {
  //Causes Rain to fall when mouse is pressed
  if (mouseX <= 660 && mouseY <= 410 && mouseX >= 640 && mouseY >= 390) {
    secret = true;
  }
  //end of if statement
}
//end of mousePressed() routine