class Player {

  float playerX;
  float playerY;
  float playerHorizontalSpeed;
  float playerVerticalSpeed;
  PVector playerPosition;
  float jumpSpeed;

  float gravity;

  boolean playerLeft;
  boolean playerRight;
  boolean playerJump;

  //Constructor
  Player() {
    playerX = 400;
    playerY = 500;
    playerHorizontalSpeed = 1;
    playerVerticalSpeed = 0;
    playerPosition = new PVector(playerX, playerY);
    jumpSpeed = -5;

    gravity = 0.5;

    playerLeft = false;
    playerRight = false;
    playerJump = false;
  }

  /*DRAW PLAYER*/
  void drawPlayer() {
    rectMode(CENTER);
    strokeWeight(3);
    stroke(0);
    fill(0, 0, 255);
    //Player character rectangle
    rect(playerPosition.x, playerPosition.y, 25, 50);
  }
  /*DRAW PLAYER*/

  /*MOVE PLAYER USING BOOLEANS FROM KEYPRESSES*/
  void playerMovement() {
    if (playerLeft) {
      //Use a speed value to change the player's position
      playerPosition.x -= playerHorizontalSpeed;
      //Increase the value that affects the player's position to create acceleration
      playerHorizontalSpeed++;
      //Limit the max speed the player can move at
      if (playerHorizontalSpeed >= 10) {
        playerHorizontalSpeed = 10;
      }
    } else if (playerRight) {
      playerPosition.x += playerHorizontalSpeed;
      playerHorizontalSpeed++;
      if (playerHorizontalSpeed >= 10) {
        playerHorizontalSpeed = 10;
      }
    }
    //If no keys are being pressed, reset the player's speed so that they accelerate again next time they move
    else {
      playerHorizontalSpeed = 1;
    }

    //The 'playerJump' is given a seperate if statement to allow for simaltaneous input with a direction. This way the player can move and jump at the same time
    playerPosition.y += playerVerticalSpeed;
    //This 'println' was used to help me know my player's y position when they were off screen, and how drastically the 'playerVerticalSpeed' affected the y position (for debugging)
    //println(playerVerticalSpeed);
    //When jumping, add the 'jumpSpeed' to the 'playerVerticalSpeed'
    if (playerJump) {
      playerVerticalSpeed += jumpSpeed;
      //This is to prevent the player from infinitely jumping off screen. This could be elaborated on by having a function that evaluates if the player has jumped, and if they have stop applying the 'jumpSpeed' to the 'playerVerticalSpeed'
      if (playerPosition.y <= 0) {
        jumpSpeed = 0;
      } else {
        jumpSpeed = -3;
      }
    } else {
      //Otherwise check to see if the player is on the ground, and if they are reset the 'playerVerticalSpeed' to zero
      if (playerPosition.y >= 500) {
        playerPosition.y = 500;
        playerVerticalSpeed = 0;
        //If the player is not on the ground, add 'gravity' to 'playerVerticalSpeed' to bring them back to the ground
      } else {
        playerVerticalSpeed += gravity;
      }
    }
  }
  /*MOVE PLAYER USING BOOLEANS FROM KEYPRESSES*/
}