
class Enemies
{
  
  //set the enemies position
  PVector enemiesPos = new PVector(0, 0);
  //set and initialize the enemies speed
  float enemiesSpeed = 0;
  //set the enemies size
  float enemiesSize;
  //temp variable
  float tempEnemiesSize;
  //temp variable
  float tempEnemiesSpeed;
  //temp variable
  float r1;
  float g1;
  float b1;


  //Initialize all variables for enemies
  Enemies(float enemiesPosX, float enemiesPosY, float tempEnemiesSpeed, float tempEnemiesSize)
  {
    enemiesSize = tempEnemiesSize;
    enemiesPos.x = enemiesPosX;
    enemiesPos.y = enemiesPosY;
    enemiesSpeed = tempEnemiesSpeed;
  }


  //draw enemies
  void drawEnemies()
  {
    //using user defined function to draw enemies(see bottom) 
    enemiesShape();
  }

  //function to define the movement of the enemies
  void moveEnemies()
  {
    //set the horizontal movement
    enemiesPos.x = enemiesPos.x + enemiesSpeed;
    //set the vertical movement(simulate gravity)
    enemiesPos.y = enemiesPos.y + speed;
    //if touches the edges, bounce back
    if (enemiesPos.x+enemiesSize>width || enemiesPos.x<0)
    {
      enemiesSpeed = enemiesSpeed*-1;
    }
    //constrain enemies inside the screen
    enemiesPos.y = constrain(enemiesPos.y, 0, height-enemiesSize);
  }

  //detect the collision between enemies and the walls and the players.
  void enemiesDetect()
  {
    //if entering right side wall, keep enemies outside the walls
    if (enemiesPos.x>wall.x && enemiesPos.x<wall.x+widthWall && enemiesPos.y+enemiesSize>wall.y && enemiesPos.y<wall.y+20)
    {
      enemiesPos.y = wall.y-enemiesSize;
    }
    //if entering left side wall, keep enemies outside the walls
    if (enemiesPos.x>walll.x && enemiesPos.x<widthWalll && enemiesPos.y+enemiesSize>walll.y  && enemiesPos.y<walll.y+20)
    {
      enemiesPos.y = walll.y-enemiesSize;
    }





    //if player hit the enemies, then enemies' size reduce to 0 and stop shooting procedure
    if (pos.x+shootWidth>enemiesPos.x && pos.x+shootWidth<enemiesPos.x+enemiesSize && pos.y+20>enemiesPos.y && pos.y+20+shootHeight<enemiesPos.y+enemiesSize && shoot == true)
    {
      shoot = false;
      enemiesSize = 0;
    }

    //if enemies get to the right bottom corner, then respawn it at the top and increase its size and random its speed.
    if (enemiesPos.y == height-enemiesSize && enemiesPos.x > width-enemiesSize-1)
    {
      int i = 0; 
      i = i+1;
      r1 = random(0, 255);
      g1 = random(0, 255);
      b1 = random(0, 255);
      enemiesPos.x=random(0);
      enemiesPos.y =random(0);
      enemiesSize = enemiesSize + i*10;
      enemiesSpeed = random(1, 10);
    }
  }













































  void enemiesShape()
  {
    fill(r1, g1, b1);
    rectMode(CORNER);
    rect(enemiesPos.x, enemiesPos.y, enemiesSize, enemiesSize);
    fill(0);
    rect( enemiesPos.x+(enemiesSize/5), 5*sin(frameCount)+enemiesPos.y+(enemiesSize/5), enemiesSize/5, enemiesSize/5);
    rect( enemiesPos.x+(3*enemiesSize/5), 5*sin(frameCount)+enemiesPos.y+(enemiesSize/5), enemiesSize/5, enemiesSize/5);
    rect( enemiesPos.x+(enemiesSize/5), 5*sin(frameCount)+enemiesPos.y+(3*enemiesSize/5), -2*sin(frameCount)+enemiesSize/2, enemiesSize/5);
  }
}