/*BUTTON SMASHER
 *Student Name: Qaisar Ali
 *Student Number: 991396429
 *Description: this is a button Smasher game where the player has to fill up the cylinder by smashing SPACE as Fast as Possible
 *Controlles: SPACE. R to restart
 */

//Declaring variabels
float liquidHeight = 500;
float liquidHeightMin = 31;
float fillSpeed = 8;
float decendSpeed = 0.5;

int score;

color buttonColor;

boolean startBubble = false;
boolean reset = false;

//Creating arrays  
Stripes[] stripes = new Stripes[8];
Stars[] stars = new Stars[200];
Bubble[] bubbleArray = new Bubble[30];

//creating Objects from classes
Button button1;
Bubble bubbles;

void setup() {
  size (800, 600);
  //Draw an object for a button
  button1 = new Button(690, 655, 681);

  //calling functions 
  createStripes();
  createStars();
  createBubbles();
  //Setting framerate to a constant 60 FPS
  frameRate(60);
}


void draw() {

  //call functions

  //DRAW
  backgroundColor();
  window();
  table();
  cylinderStand();
  liquid();
  cylinder();
  //Update
  displayBubbles();
  restartGame();
  gameOver();
  //Calls a function from another class
  button1.drawButton();
}

//Function For background
void backgroundColor() {
  background(253, 175, 142);
  displayStripes();
}

//Draws Cylinder
void cylinder() {
  rectMode(CORNERS);
  stroke(0);
  strokeWeight(1);
  fill(227, 104, 47);
  rect(340, 10, 440, 30);
  
  
  fill(154, 230, 253, 100);
  rect(350, 30, 430, 500);

  fill(255, 150);
  noStroke();
  rect(360, 40, 380, 480, 15);
  
}
//Draws Cylinder's Stand
void cylinderStand() {
  rectMode(CORNERS);
  noStroke();
  fill(10,200);
  rect(344, 455, 444, 555);
  rect(344, 555, 444, 570);
  stroke(0);
  strokeWeight(1);
  fill(227, 104, 47);
  rect(340, 450, 440, 550);
  rect(340, 550, 440, 565);
 
}

//Draws the table/Ground
void table() {
  rectMode(CORNERS);
  stroke(0);
  strokeWeight(2);
  fill(137, 78, 64);
  rect(0, 400, 800, 600);
}

//Draw window
void window() {
  rectMode(CORNERS);
  fill(82, 107, 104);

  rect(100, 50, 700, 200);
  fill(18, 28, 40);

  rect(110, 60, 690, 190);
  //calls the function that displays the stars here so they can apear behind the window
  displayStars();
  //Draw glare
  noStroke();
  fill(255, 60);
  triangle(580, 100, 600, 100, 630, 70);
  triangle(570, 180, 630, 180, 680, 70);
  fill(82, 107, 104);
  rect(110, 120, 690, 130);
  rect(400, 60, 410, 190);
}

//sets the height of the liquid and then draws it
void liquid() {
  fill(0, 0, 255);

  for (int i=  0; i<score; i++) {
    //depending on where the liquid is the liquid will be harder to  go higher
    if (liquidHeight <= 500 && liquidHeight >= 300) { 
      liquidHeight = liquidHeight+decendSpeed/100;
    } else if (liquidHeight <= 300 &&liquidHeight >= 100) { 
      liquidHeight = liquidHeight+decendSpeed/70;
    } else if (liquidHeight <= 100 && liquidHeight >= 31) { 
      liquidHeight = liquidHeight+decendSpeed/60;
    } else if (liquidHeight == liquidHeightMin) { 
      liquidHeight = liquidHeightMin;
    }
  }

  rect(350, liquidHeight, 430, 500);
}

//Creates key Functions. if SPACE is pressed the liquid height goes up and when r is pressed the game restarts
void keyReleased() {

  if (key == ' ') {
    //creates a random colour everytime space is pressed
    buttonColor = color (random(100, 255), random(100, 255), random(0, 255));
    //only adds score if the liquid is not maxed out in the cylinder yet
    if (liquidHeight >liquidHeightMin) {
      score = score+1;
      //makes it so the liquid keeps going down as the player work their way to the top
      liquidHeight -= fillSpeed;
    }
  }
  //key for restart
  if (key == 'r') {
    reset = true;
  }
}


//draws text to let the player know how many time they pressed the space button and if the want to restart the game
void gameOver() {
  if (liquidHeight < liquidHeightMin) {
    textSize(40);
    fill(random(100, 255), random(100, 255), random(200, 255)); 
    //set a boolean to true so that the bubbles can start flowing up whent the game is over
    startBubble = true;
    //if bubbles start flowing display the below text
    if (startBubble == true) {

      text("You Pressed SPACE: " + score + " times", 140, 300);
      fill(0);
      text("Press R to restart", 5, 30);
    }
  }
}


//function that creates a for loop and puts a stripe class object in every 100th 'i' meaning it will put a stripe every 100 x axis till the end of the array length
void createStripes() {

  for (int i= 0; i < stripes.length; i++) {
    stripes[i] = new Stripes(i*100);
  }
}

//function that calls another function from class stripe and puts and draws that in every object of the array.
void displayStripes() {
  for (int i =0; i<stripes.length; i++) {
    stripes[i].drawStripe();
  }
}

//funtion that put an object from another class in every object of the at a certain random location on screen
void   createStars() {
  for (int i = 0; i< stars.length; i++) {
    stars[i] = new Stars( random( 110, 690), random(60, 190));
  }
}

//function that calls another function from class  and puts and draws that in every object of the array.
void   displayStars() {
  for (int i = 0; i< stars.length; i++) {
    stars[i].drawStars();
  }
}

//in every object of the array a new object is put 
void createBubbles() {
  for (int i =0; i < bubbleArray.length; i++) {
    bubbleArray[i] = new Bubble();
  }
}

//draws and updates the objects in the array using two functions from class Bubbles
void displayBubbles() {
  for (int i =0; i < bubbleArray.length; i++) {
    bubbleArray[i].drawBubble(); 
    bubbleArray[i].updateBubble();
  }
}

//function to restart the game
void restartGame() {
  if (reset == true) {
    startBubble = false;
    liquidHeight = 500;
    score = 0;
    reset = false;
  }
}