class Asteroids {
  boolean isSpawned;
  PVector position;
  PVector velocity;
  PVector asteroidSize;
  Asteroids(float tempX, float tempY, float tempXVelocity, float tempYVelocity, float tempXSize, float tempYSize, boolean tempIsSpawned) {
    position = new PVector(tempX, tempY);
    velocity = new PVector(tempXVelocity, tempYVelocity);
    asteroidSize = new PVector(tempXSize, tempYSize);
    isSpawned=tempIsSpawned;
  }

  void update() {
    //if the asteroid leaves the screen, it is no longer "spawned".
    if (position.y>400||position.x>500||position.x<-100) {
      isSpawned=false;
    }
    //Check for Collision with player. If right side of ship, destroy right cargo, if left side then destroy left cargo. If no cargo exists then just damage player.
    if (isSpawned==true) {
      if (position.x>=(playerShip.xPos-50) && position.x<=(playerShip.xPos+50) && position.y>=(playerShip.yPos-50) && position.y<=(playerShip.yPos+50)) {
        if (position.x>playerShip.xPos && playerShip.isRightCargo==true) {
          playerShip.isRightCargo=false;
          playerShip.cargoRightWeight=0;
        } else if (position.x<playerShip.xPos && playerShip.isLeftCargo==true) {
          playerShip.isLeftCargo=false;
          playerShip.cargoLeftWeight=0;
        } else if (position.x>playerShip.xPos && playerShip.isRightCargo==false && playerShip.isLeftCargo==true) {
          playerShip.isLeftCargo=false;
          playerShip.cargoLeftWeight=0;
        } else if (position.x<playerShip.xPos && playerShip.isRightCargo==true && playerShip.isLeftCargo==false) {
          playerShip.isRightCargo=false;
          playerShip.cargoRightWeight=0;
        }
        isSpawned=false;
        playerShip.health-=1;
        playerShip.dampening=3;
      }
    }
  }
  void display() {
    //Only draw the asteroid if it is spawned.
    if (isSpawned==true) {
      position.add(velocity);
      position.x+=playerShip.horizontalSpeed;
      position.y+=playerShip.verticalSpeed;
      fill(200, 100, 50);
      ellipse(position.x, position.y, asteroidSize.x, asteroidSize.y);
    }
  }
}