class Spaceship {
  int xPos;
  int yPos;
  int health;
  float energy, maxEnergy, energyPercentage;
  color shipColour;
  //Speed Variables
  float verticalSpeed;
  float horizontalSpeed;
  float verticalAcceleration;
  float horizontalAcceleration;
  float cargoRightWeight;
  float cargoLeftWeight;
  float dampening;
  boolean isRightCargo=true;
  boolean isLeftCargo=true;
  boolean isAlive=true;
  Spaceship(int tempXPos, int tempYPos, int tempHealth, float tempEnergy, color tempColour) {
    xPos=tempXPos;
    yPos=tempYPos;
    health=tempHealth;
    maxEnergy=tempEnergy;
    energy=maxEnergy;
    shipColour=tempColour;
    cargoRightWeight=1.2;
    cargoLeftWeight=1.2;
    constrain(horizontalSpeed, -10, 10);
    constrain(verticalSpeed, 0, 10);
  }
  void update() {
    //If the player's health is zero, they are dead.
    if (health<=0) {
      isAlive=false;
    }
    //Update Energy Consumption
    float energyConsumption;
    energyConsumption=1-(verticalAcceleration);
    energyPercentage=(energy/maxEnergy);
    //println(energyConsumption);
    energy=energy+energyConsumption;
    if (energy>=maxEnergy) {
      energy=maxEnergy;
    }
    if (energy<=0) {
      energy=0;
    }
  }
  void movement() {
    //The higher the mouse position is on the screen, the higher the vertical acceleration.
    dampening-=.2;
    verticalAcceleration=(200-mouseY)/100.00;
    if (verticalAcceleration<=0) {
      verticalAcceleration=0;
    }
    //Max Speed is determined by mouse position and cargo weight.
    float maxSpeed=constrain(((200-mouseY)/10.00)-(cargoRightWeight+cargoLeftWeight), 1, 20);
    if (energy<=0) {
      verticalSpeed=1;
    } else {
      //Vertical Speed is between 1 and the max speed.
      verticalSpeed=constrain(verticalSpeed+verticalAcceleration-dampening, 1, maxSpeed);
    }
    //println(verticalAcceleration);
    //println(verticalSpeed);
    //println((200-mouseY)/10.00);
    horizontalAcceleration=(200-mouseX)/100.00;
    //Horizontal Speed can go both directions, and there's drift for each cargo pod.
    horizontalSpeed=constrain(horizontalSpeed+horizontalAcceleration-cargoLeftWeight+cargoRightWeight, -10, 10);
  }
  void display() {
    rectMode(CENTER);
    ellipseMode(RADIUS);
    noStroke();
    //Thruster Fires
    //Appear larger when player is accelerating faster.
    fill(255, 255, 0);
    ellipse(xPos+15, yPos+25+(verticalAcceleration*2), 5, random(15+verticalAcceleration, 20+verticalAcceleration));
    ellipse(xPos-15, yPos+25+(verticalAcceleration*2), 5, random(15+verticalAcceleration, 20+verticalAcceleration));
    //SHIP
    fill(100);
    rect(xPos+10, yPos-30, 5, 30);
    rect(xPos+15, yPos+25, 10, 30);
    rect(xPos-15, yPos+25, 10, 30);
    fill(shipColour);
    ellipse(xPos, yPos-20, 10, 30);
    ellipse(xPos, yPos, 20, 40);
    triangle(xPos+10, yPos-10, xPos+30, yPos-10, xPos+30, yPos+40);
    triangle(xPos-10, yPos-10, xPos-30, yPos-10, xPos-30, yPos+40);
    fill(0, 0, 255);
    triangle(xPos, yPos-40, xPos+5, yPos-40, xPos, yPos-45);
    triangle(xPos, yPos-40, xPos-5, yPos-40, xPos, yPos-45);
    //RightCARGO
    if (isRightCargo==true) {
      fill(90);
      rect(xPos+40, yPos+20, 20, 60);
      fill(50);
      rect(xPos+40, yPos+20, 10, 50);
      for (int i=10; i<50; i+=10) {
        fill(90);
        rect(xPos+40, yPos-5+i, 20, 2.5);
      }
    }

    //LeftCARGO
    if (isLeftCargo==true) {
      fill(90);
      rect(xPos-40, yPos+20, 20, 60);
      fill(50);
      rect(xPos-40, yPos+20, 10, 50);
      for (int i=10; i<50; i+=10) {
        fill(90);
        rect(xPos-40, yPos-5+i, 20, 2.5);
      }
    }

    //Energy Bar
    rectMode(CORNERS);
    fill(30);
    rect(xPos-5, yPos+20, xPos+5, yPos-20);
    fill(200, 200, 0);
    rect(xPos-5, yPos+20, xPos+5, yPos+20-(40*energyPercentage));
  }
}