/**********************************************************
 Introduction to Media Computation
 Assignment 3 Object-oriented Toy
 Richard Scott Duff
 PROG14998 
 
 WASD to move.
 Space to start.
 
 
 **********************************************************/
//this is used to see if the player has gone of the screen.//
boolean movedScreen = false;

// checks the amount of collectables//
int collectableChecker;

//int to keep track of the players score//
int score;


//boolean used to tell if the player reset should be true or not//
boolean playerResetT;
boolean playerResetB;
boolean playerResetL;
boolean playerResetR;

// changing the background color
float randomR;
float randomG;


// calling the player class and creating an object
player player1;

// creating an array list  called tileRandom from the tiles class//
int arraySize;
ArrayList<collectable> collectables = new ArrayList<collectable>();



void setup()
{
  size(400, 400);
  background(255);

  // this is going to be used for checking which tile to spawn//
  collectableChecker = 0;

  //int to keep track of the players score//
  score = 0;

  //setting the collision bools//
  playerResetT = false;
  playerResetB = false;
  playerResetL = false;
  playerResetR = false;


  randomR = 255;
  randomG = 255;
  // setting the player object
  player1 = new player(width/2, height/2);


  arraySize = 20;
  ////setting the tileRandom to have tiles inside of it which are set to random sizes//
  for (int i = 0; i < arraySize; i++)
  {
    collectables.add(new collectable(random(25, 375), random(25, 375)));
  }

  //// This is checking to see the size of the tileRandom array//
  //int total = tileRandom.size();
  //println("The total number of tiles is: " + total);
}

void draw()
{
  background(randomR, randomG, 0);

  startScreen();

  // update the player object //
  player1.updatePlayer();
  updatePlayer();

  drawCollectables();

  // display the player object//
  player1.displayPlayer();

  winCondition();
}


// playerUpdate Function here is doing collision detection and giving the conditions to spawn the next tile.//
void updatePlayer()
{
  // this is checking to see if the player has met the conditions to move to a new tile from the top part of the screen//
  if (player1.position.y < 10)
  {
    movedScreen = true;
    playerResetT = true;
  }

  //This is checking to see if the player has met the conditions to move to a new tile from the top part of the screen//
  if (player1.position.y > height)
  {
    movedScreen = true;
    playerResetB = true;
  }

  if (player1.position.x < 0)
  {    
    movedScreen = true;
    playerResetL = true;
  }

  if (player1.position.x > width)
  {    
    movedScreen = true;
    playerResetR = true;
  }

  // if the player meets the condintions to move to a new tile then draw the new tile.//
  if (movedScreen == true)
  {   
    //this part of the code is reseting the player if the player leaves a tile from the top//
    if (playerResetT == true)
    {
      player1 = new player(player1.position.x, 390);
      playerResetT = false;
    }

    //this part of the code is reseting the player if the player leaves a tile from the bottom//
    if (playerResetB == true)
    {
      player1 = new player(player1.position.x, 10);
      playerResetB = false;
    }

    if (playerResetL == true)
    {
      player1 = new player(390, player1.position.y);
      playerResetL = false;
    }

    if (playerResetR == true)
    {
      player1 = new player(0, player1.position.y);
      playerResetR = false;
    }
  }
}

void drawCollectables()
{

  // This is checking to see if the collectableChecker is greater than 0 if so then start spawning the collectables.//
  if (collectableChecker > 0 )
  {
    // call the tile out of the tileRandom array list// 
    collectable coll = collectables.get(collectableChecker);
    coll.spawnCollectable = true;
    coll.displayCollectable();

    //This is where i'm calling the true/false math i made with the help of bruce and then telling it to do something if returned true and do nothing if returned false.
    //This statement is also how i'm passing the title(emeniesPos) and tile(enemies Size) to my player class.
    if (player1.playerCollision(coll.getPos(), coll.getRad()))
    {
      collectables.remove(collectableChecker);
      score++;
      randomR = random(5, 255);
      randomG = random(5, 255);
      println(score);
    }
  }
}




void winCondition()
{
  // when the score reaches 15 draw a new background  and display the "You Win" text on screen//
  if (score == 15)
  {
    background(255);
    fill(0);
    stroke(10);
    text("YOU WIN", 170, 50);
  }
}

void startScreen()
{
  //this is saying if the collectableChecker is 0 which is what the program starts on then display the start screen which explains how to win and the controls.
  if (collectableChecker == 0)
  {
    fill(0);
    text("WASD to move. Press Space to start. Collect 15 orbs and you win!", 20, 50);
  }
}




void keyPressed()
{
  if (key == 'w' || key == 'W')
  {
    //calling a boolean from the player class and then setting it to true//
    player1.movedUp = true;
  }

  if (key == 's' || key == 'S')
  {
    //calling a boolean from the player class and then setting it to true//
    player1.movedDown = true;
  }

  if (key == 'a' || key == 'A')
  {
    //calling a boolean from the player class and then setting it to true//
    player1.movedLeft = true;
  }

  if (key == 'd' || key == 'D')
  {
    //calling a boolean from the player class and then setting it to true//
    player1.movedRight = true;
  }

  if (key == ' ')
  {
    collectableChecker = 1;
  }
}

void keyReleased()
{
  if (key == 'w' || key == 'W')
  {
    //calling a boolean from the player class and then setting it to false//
    player1.movedUp = false;
  }

  if (key == 's' || key == 'S')
  {
    //calling a boolean from the player class and then setting it to false//
    player1.movedDown = false;
  }

  if (key == 'a' || key == 'A')
  {
    //calling a boolean from the player class and then setting it to false//
    player1.movedLeft = false;
  }

  if (key == 'd' || key == 'D')
  {
    //calling a boolean from the player class and then setting it to false//
    player1.movedRight = false;
  }
}