//Checkers - Object Oriented Toy Assignment
//PROG 14998 - Intro To Media Computation
//by: Sean Grafton, Student ID: 991420843

class CheckerPiece {
  PVector coordinate;
  char teamColour;
  boolean kingMe;
  boolean inPlay;
  boolean onSideBoard;
  PVector offBoardCoords;

  CheckerPiece(PVector coord, char team) {
    coordinate = coord;
    teamColour = team;
    kingMe = false;
    inPlay = true;
    if (teamColour == 'r') {
      offBoardCoords= new PVector(20, random(100, 500));
    } else {
      offBoardCoords= new PVector(720, random(100, 500));
    }
  }

  void drawPiece() {
    if (teamColour == 'b') {
      fill(0);
    } else if (teamColour == 'r') {
      fill(255, 0, 0);
    }
    stroke(100, 100, 100);
    ellipseMode(CORNER);
    if (inPlay) {
      ellipse((coordinate.x * 70) + 125, (coordinate.y * 70) + 25, 60, 60);
      ellipse((coordinate.x * 70) + 135, (coordinate.y * 70) + 35, 40, 40);
      if (kingMe == true) {
        drawKing();
      }
    } else {
      ellipse(offBoardCoords.x, offBoardCoords.y, 60, 60);
      ellipse(offBoardCoords.x+10, offBoardCoords.y+10, 40, 40);
    }
  }
  void drawKing() {
    //crown
    fill(255);
    noStroke();
    ellipseMode(CORNER);
    ellipse((coordinate.x * 70) + 152, (coordinate.y * 70) + 45, 7, 7);
    ellipse((coordinate.x * 70) + 136, (coordinate.y * 70) + 45, 7, 7);
    ellipse((coordinate.x * 70) + 168, (coordinate.y * 70) + 45, 7, 7);
    triangle((coordinate.x * 70) + 140, (coordinate.y * 70) + 55, (coordinate.x * 70) + 140, (coordinate.y * 70) + 60, (coordinate.x * 70) + 148, (coordinate.y * 70) + 60);
    triangle((coordinate.x * 70) + 148, (coordinate.y * 70) + 60, (coordinate.x * 70) + 155, (coordinate.y * 70) + 55, (coordinate.x * 70) + 162, (coordinate.y * 70) + 60);
    triangle((coordinate.x * 70) + 162, (coordinate.y * 70) + 60, (coordinate.x * 70) + 170, (coordinate.y * 70) + 60, (coordinate.x * 70) + 170, (coordinate.y * 70) + 55);
    rect((coordinate.x * 70) + 140, (coordinate.y * 70) + 60, 30, 5);
  }
}