//Checkers - Object Oriented Toy Assignment
//PROG 14998 - Intro To Media Computation
//by: Sean Grafton, Student ID: 991420843

//This is a game of checkers. Players take turns moving checkers.
//the board spins to accomodate the current player's turn and perspective
//the game also highlights mandatory moves and flashes possible moves

// global variables
//board and pieces
CheckerBoard board = new CheckerBoard();
CheckerPiece[] redTeam = new CheckerPiece[12];
CheckerPiece[] blackTeam = new CheckerPiece[12];
//variables for generating board and standard pieces
boolean placePiece = true;
int checkerCount = 0;
//turn order
char teamTurn = 'r';
//variables to hold current list of pieces that can move/attack
ArrayList<CheckerPiece> possibleAttacks = new ArrayList();
ArrayList<CheckerSquare> attackSquares = new ArrayList();
ArrayList<CheckerPiece> possibleMoves = new ArrayList();
ArrayList<CheckerSquare> moveSquares = new ArrayList();
CheckerPiece selectedPiece;
boolean canChooseMove = false;
boolean moveChosen = false;
boolean canAttackAgain = false;
CheckerSquare selectedSquare;
//winConditions
boolean noMoreRed = false;
boolean noMoreBlack = false;

//setup: set screen size, frame rate, and populate the teams with their pieces
void setup() {
  size(800, 600);
  strokeWeight(3);
  frameRate(10);
  //red team
  for (int x = 0; x < 3; x++) {
    for (int y = 0; y < 8; y++) {
      if (placePiece == true) {
        redTeam[checkerCount] = new CheckerPiece(new PVector(x, y), 'r');
        checkerCount ++;
        if (y < 7) {
          placePiece = false;
        }
      } else {
        if (y < 7) {
          placePiece = true;
        }
      }
    }
  }
  checkerCount = 0;
  placePiece = false;
  for (int a = 5; a < 8; a++) {
    for (int b = 0; b < 8; b++) {
      if (placePiece == true) {
        blackTeam[checkerCount] = new CheckerPiece(new PVector(a, b), 'b');
        checkerCount ++;
        if (b < 7) {
          placePiece = false;
        }
      } else {
        if (b < 7) {
          placePiece = true;
        }
      }
    }
  }
}

//draw: ensure that squares are identified as being occupied
//draw the board and pieces
//highlight which team is playing
void draw() {
  noMoreRed = true;
  noMoreBlack = true;
  for (int x = 0; x < redTeam.length; x++) {
    if (redTeam[x].inPlay == true) {
      noMoreRed = false;
    }
  }
  for (int y = 0; y < redTeam.length; y++) {
    if (blackTeam[y].inPlay == true) {
      noMoreBlack = false;
    }
  }
  if (noMoreRed) {
    blackWin();
  } else if (noMoreBlack) {
    redWin();
  } else {
    occupySquares();
    board.drawBoard();
    crownKings();
    drawPieces();
    if (teamTurn == 'b') {
      noFill();
      rect(707, 7, 85, 30);
    } else {
      noFill();
      rect(7, 7, 85, 30);
    }
  }
}

//displays P1 WIN
void redWin() {
  noStroke();
  fill(255);
  rect(0, 0, 800, 600);
  fill(255, 0, 0);
  //P
  rect(150, 50, 30, 170);
  rect(180, 50, 50, 30);
  rect(180, 110, 50, 30);
  quad(230, 50, 230, 140, 260, 110, 260, 80);
  //1
  triangle(290, 100, 320, 100, 320, 50);
  rect(320, 50, 30, 140);
  rect(290, 190, 80, 30);
  //W
  rect(290, 300, 30, 170);
  rect(320, 470, 30, 30);
  rect(350, 410, 30, 60);
  rect(380, 470, 30, 30);
  rect(410, 300, 30, 170);
  //I
  rect(460, 300, 90, 30);
  rect(490, 300, 30, 200);
  rect(460, 470, 90, 30);
  //N
  rect(580, 300, 30, 200);
  rect(610, 300, 30, 30);
  rect(640, 330, 30, 60);
  rect(670, 390, 30, 30);
  rect(700, 300, 30, 200);
}

//displays P2 WIN
void blackWin() {
  noStroke();
  fill(255);
  rect(0, 0, 800, 600);
  fill(0);
  //P
  rect(150, 50, 30, 170);
  rect(180, 50, 50, 30);
  rect(180, 110, 50, 30);
  quad(230, 50, 230, 140, 260, 110, 260, 80);
  //2
  rect(300, 80, 30, 30);
  triangle(300, 80, 330, 80, 330, 50);
  rect(330, 50, 50, 30);
  triangle(380, 50, 380, 80, 410, 80);
  rect(380, 80, 30, 60);
  quad(380, 140, 410, 140, 330, 190, 300, 190);
  rect(300, 190, 110, 30);
  //W
  rect(290, 300, 30, 170);
  rect(320, 470, 30, 30);
  rect(350, 410, 30, 60);
  rect(380, 470, 30, 30);
  rect(410, 300, 30, 170);
  //I
  rect(460, 300, 90, 30);
  rect(490, 300, 30, 200);
  rect(460, 470, 90, 30);
  //N
  rect(580, 300, 30, 200);
  rect(610, 300, 30, 30);
  rect(640, 330, 30, 60);
  rect(670, 390, 30, 30);
  rect(700, 300, 30, 200);
}

//occupySquares ensures that squares that have a piece on them are identified as being occupied
void occupySquares() {
  //clear previous states
  for (int x = 0; x < board.squareList.length; x++) {
    for (int y = 0; y < board.squareList[x].length; y++) {
      board.squareList[x][y].occupiedState = false;
      board.squareList[x][y].teamOccupying = 'n';
    }
  }
  //go through red team
  for (int y = 0; y < redTeam.length; y++) {
    if (redTeam[y].inPlay == true) {
      board.squareList[int(redTeam[y].coordinate.x)][int(redTeam[y].coordinate.y)].occupiedState = true;
      board.squareList[int(redTeam[y].coordinate.x)][int(redTeam[y].coordinate.y)].teamOccupying = 'r';
    }
  }
  //go through black team
  for (int a = 0; a < blackTeam.length; a++) {
    if (blackTeam[a].inPlay == true) {
      board.squareList[int(blackTeam[a].coordinate.x)][int(blackTeam[a].coordinate.y)].occupiedState = true;
      board.squareList[int(blackTeam[a].coordinate.x)][int(blackTeam[a].coordinate.y)].teamOccupying = 'b';
    }
  }
}

//this function checks if any peice has made it to the other side.
//it then makes that piece Kinged.
void crownKings() {
  for (int x = 0; x < redTeam.length; x++) {
    if (redTeam[x].coordinate.x == 7) {
      redTeam[x].kingMe = true;
    }
  }
  for (int y = 0; y < blackTeam.length; y++) {
    if (blackTeam[y].coordinate.x == 0) {
      blackTeam[y].kingMe = true;
    }
  }
}

//drawPieces makes sure all peices are displayed
void drawPieces() {
  for (int x = 0; x < 12; x ++) {
    redTeam[x].drawPiece();
  }
  for (int y = 0; y < 12; y ++) {
    blackTeam[y].drawPiece();
  }
}

//mouseClicked conditionals and functions are triggered here
void mouseClicked() {
  //first find any possible attacks
  occupySquares();
  findAttacks();
  if ((possibleAttacks.size() == 0)&&(canAttackAgain == false)) {
    //if you can't find any attacks, find any possible moves
    findMoves();
  }
  //if a piece has been selected
  if (canChooseMove == true) {
    //check to see if a valid move has been clicked on. if yes, move the selectedPiece there
    chooseMove();
    //if a valid move is chosen
    if (moveChosen) {
      if (possibleAttacks.size() > 0) {
        canAttackAgain = true;
        possibleAttacks = new ArrayList();
        attackSquares = new ArrayList();
        occupySquares();
        findAttacks();
        if (possibleAttacks.size() > 0) {
          moveChosen = false;
          canChooseMove = false;
          possibleAttacks = new ArrayList();
          attackSquares = new ArrayList();
          possibleMoves = new ArrayList();
          moveSquares = new ArrayList();
        } else {
          canChooseMove = false;
          moveChosen = false;
          canAttackAgain = false;
          possibleAttacks = new ArrayList();
          attackSquares = new ArrayList();
          possibleMoves = new ArrayList();
          moveSquares = new ArrayList();
          swapTeams();
        }
      } else {
        canChooseMove = false;
        moveChosen = false;
        canAttackAgain = false;
        possibleAttacks = new ArrayList();
        attackSquares = new ArrayList();
        possibleMoves = new ArrayList();
        moveSquares = new ArrayList();
        occupySquares();
        swapTeams();
      }
    }
  }
  //check to see if a moveable piece has been clicked on
  if ((moveChosen == false)&&(pieceSelected() == true)) {
    //if yes, display that pieces valid moves
    attackSquares = new ArrayList();
    moveSquares = new ArrayList();
    board = new CheckerBoard();
    occupySquares();
    board.drawBoard();
    drawPieces();
    canChooseMove = true;
    showMoves();
  }
}
//swapTeams changes which team is currently playing
void swapTeams() {
  if (teamTurn == 'b') {
    teamTurn = 'r';
  } else {
    teamTurn = 'b';
  }
}

//findAttacks determines if a piece can attack
//process: check the teamTurn
//-------- if its a Kinged Piece
//----------- if its near the border in either direction (index 0,1,6,7), can only move into the center
//----------- otherwise, can attack in any direction so long as
//-------------- there is an empty space two spaces away
//-------------- and the space in between is occupied by the opposing team
//-------- if its a normal piece
//----------- if its near the top, bottom, or far side boarder (index 0,1,6,7), can only attack into the center, if at all
//----------- otherwise, can attack in a forwards direction so long as
//-------------- there is an empty space two spaces away
//-------------- and the space in between is occupied by the opposing team
void findAttacks() {
  if (teamTurn == 'r') {
    for (int x = 0; x < redTeam.length; x++) {
      if (redTeam[x].inPlay == true) {
        if (redTeam[x].kingMe == true) {
          if (int(redTeam[x].coordinate.x) > 5) {
            if (int(redTeam[x].coordinate.y) < 2) {
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) - 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            } else if (int(redTeam[x].coordinate.y) > 5) {
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) - 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            } else {
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) - 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) - 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            }
          } else if (int(redTeam[x].coordinate.x) < 2) {
            if (int(redTeam[x].coordinate.y) < 2) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            } else if (int(redTeam[x].coordinate.y) > 5) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            } else {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            }
          } else {
            if (int(redTeam[x].coordinate.y) < 2) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) - 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            } else if (int(redTeam[x].coordinate.y) > 5) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) - 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            } else {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) - 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) - 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            }
          }
        } else {
          if (int(redTeam[x].coordinate.x) > 5) {
            //can't attack
          } else {
            if (int(redTeam[x].coordinate.y) < 2) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            } else if (int(redTeam[x].coordinate.y) > 5) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            } else {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].teamOccupying == 'b') {
                  if (board.squareList[int(redTeam[x].coordinate.x) + 2][int(redTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(redTeam[x]);
                  }
                }
              }
            }
          }
        }
      }
    }
  } else {
    for (int x = 0; x < blackTeam.length; x++) {
      if (blackTeam[x].inPlay == true) {
        if (blackTeam[x].kingMe == true) {
          if (int(blackTeam[x].coordinate.x) > 5) {
            if (int(blackTeam[x].coordinate.y) < 2) {
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            } else if (int(blackTeam[x].coordinate.y) > 5) {
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            } else {
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            }
          } else if (int(blackTeam[x].coordinate.x) < 2) {
            if (int(blackTeam[x].coordinate.y) < 2) {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) + 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            } else if (int(blackTeam[x].coordinate.y) > 5) {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) + 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            } else {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) + 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) + 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            }
          } else {
            if (int(blackTeam[x].coordinate.y) < 2) {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) + 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            } else if (int(blackTeam[x].coordinate.y) > 5) {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) + 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            } else {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) + 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) + 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            }
          }
        } else {
          if (int(blackTeam[x].coordinate.x) < 2) {
            //can't attack
          } else {
            if (int(blackTeam[x].coordinate.y) < 2) {
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            } else if (int(blackTeam[x].coordinate.y) > 5) {
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            } else {
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) + 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].teamOccupying == 'r') {
                  if (board.squareList[int(blackTeam[x].coordinate.x) - 2][int(blackTeam[x].coordinate.y) - 2].occupiedState == false) {
                    possibleAttacks.add(blackTeam[x]);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
}
//findMoves determines if a piece can move
//process: check the teamTurn
//-------- if its a Kinged Piece
//----------- if its near the border in either direction (index 0,7), can only move into the center
//----------- otherwise, can move in any direction so long as
//-------------- there is an empty space one space away
//-------- if its a normal piece
//----------- if its near the top, bottom, or far side boarder direction (index 0,7), can only move into the center
//----------- otherwise, can move in a forwards direction so long as
//-------------- there is an empty space one space away
void findMoves() {
  if (teamTurn == 'r') {
    for (int x = 0; x < redTeam.length; x++) {
      if (redTeam[x].inPlay == true) {
        if (redTeam[x].kingMe == true) {
          if (int(redTeam[x].coordinate.x) == 7) {
            if (int(redTeam[x].coordinate.y) == 0) {
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
            } else if ((int(redTeam[x].coordinate.y) == 6)||(int(redTeam[x].coordinate.y) == 7)) {
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
            } else {
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
            }
          } else if (int(redTeam[x].coordinate.x) == 0) {
            if (int(redTeam[x].coordinate.y) == 0) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
            } else if (int(redTeam[x].coordinate.y) == 7) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
            } else {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
            }
          } else {
            if (int(redTeam[x].coordinate.y) == 0) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
            } else if (int(redTeam[x].coordinate.y) == 7) {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
            } else {
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
              if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
              if (board.squareList[int(redTeam[x].coordinate.x) - 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(redTeam[x]);
              }
            }
          }
        } else {
          if (int(redTeam[x].coordinate.y) == 0) {
            if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
              possibleMoves.add(redTeam[x]);
            }
          } else if (int(redTeam[x].coordinate.y) == 7) {
            if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
              possibleMoves.add(redTeam[x]);
            }
          } else {
            if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) - 1].occupiedState == false) {
              possibleMoves.add(redTeam[x]);
            }
            if (board.squareList[int(redTeam[x].coordinate.x) + 1][int(redTeam[x].coordinate.y) + 1].occupiedState == false) {
              possibleMoves.add(redTeam[x]);
            }
          }
        }
      }
    }
  } else {
    for (int x = 0; x < blackTeam.length; x++) {
      if (blackTeam[x].inPlay == true) {
        if (blackTeam[x].kingMe == true) {
          if (int(blackTeam[x].coordinate.x) == 7) {
            if (int(blackTeam[x].coordinate.y) == 0) {
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
            } else if (int(blackTeam[x].coordinate.y) == 7) {
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
            } else {
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
            }
          }
          if (int(blackTeam[x].coordinate.x) == 0) {
            if (int(blackTeam[x].coordinate.y) == 0) {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
            } else if (int(blackTeam[x].coordinate.y) == 7) {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
            } else {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
            }
          } else {
            if (int(blackTeam[x].coordinate.y) == 0) {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
            } else if (int(blackTeam[x].coordinate.y) == 7) {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
            } else {
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) + 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
              if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
                possibleMoves.add(blackTeam[x]);
              }
            }
          }
        } else {
          if (int(blackTeam[x].coordinate.y) == 0) {
            if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
              possibleMoves.add(blackTeam[x]);
            }
          } else if (int(blackTeam[x].coordinate.y) == 7) {
            if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
              possibleMoves.add(blackTeam[x]);
            }
          } else {
            if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) - 1].occupiedState == false) {
              possibleMoves.add(blackTeam[x]);
            }
            if (board.squareList[int(blackTeam[x].coordinate.x) - 1][int(blackTeam[x].coordinate.y) + 1].occupiedState == false) {
              possibleMoves.add(blackTeam[x]);
            }
          }
        }
      }
    }
  }
}

//checks to see if a moveable piece has been clicked on
//changes selectedPiece and returns true if yes
boolean pieceSelected() {
  boolean didIDoIt = false;
  if (possibleAttacks.size() > 0) {
    for (int x = 0; x < possibleAttacks.size(); x++) {
      if ((mouseX>=(possibleAttacks.get(x).coordinate.x * 70) + 120)&&(mouseX<=(possibleAttacks.get(x).coordinate.x * 70) + 190)) {
        if ((mouseY>=(possibleAttacks.get(x).coordinate.y * 70) + 20)&&(mouseY<=(possibleAttacks.get(x).coordinate.y * 70) + 90)) {
          selectedPiece = possibleAttacks.get(x);
          didIDoIt = true;
        }
      }
    }
  } else {
    for (int x = 0; x < possibleMoves.size(); x++) {
      if ((mouseX>=(possibleMoves.get(x).coordinate.x * 70) + 120)&&(mouseX<=(possibleMoves.get(x).coordinate.x * 70) + 190)) {
        if ((mouseY>=(possibleMoves.get(x).coordinate.y * 70) + 20)&&(mouseY<=(possibleMoves.get(x).coordinate.y * 70) + 90)) {
          selectedPiece = possibleMoves.get(x);
          didIDoIt = true;
        }
      }
    }
  }
  return didIDoIt;
}

// Show moves uses the same logical processes as findAttacks and findMoves
// but instead of storing the peice that can move, it stores the square the selected piece can move to
// it then changes those squares to an appropriate colour: blue for a move, green for an attack
void showMoves() {
  if (teamTurn == 'r') {
    if (selectedPiece.kingMe == true) {
      if (possibleAttacks.size() > 0) {
        if (selectedPiece.coordinate.x < 2) {
          if (selectedPiece.coordinate.y < 2) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
          } else if (selectedPiece.coordinate.y > 5) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          }
        } else if (selectedPiece.coordinate.x > 5) {
          if (selectedPiece.coordinate.y < 2) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
          } else if (selectedPiece.coordinate.y > 5) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          }
        } else {
          if (selectedPiece.coordinate.y < 2) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
          } else if (selectedPiece.coordinate.y > 5) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          }
        }
      } else {
        if (selectedPiece.coordinate.x < 1) {
          if (selectedPiece.coordinate.y < 1) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
            }
          } else if (selectedPiece.coordinate.y > 6) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
            }
          }
        } else if (selectedPiece.coordinate.x > 6) {
          if (selectedPiece.coordinate.y < 1) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
            }
          } else if (selectedPiece.coordinate.y > 6) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
            }
          }
        } else {
          if (selectedPiece.coordinate.y < 1) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
            }
          } else if (selectedPiece.coordinate.y > 6) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
            }
          }
        }
      }
    } else {
      if (possibleAttacks.size() > 0) {
        if (selectedPiece.coordinate.y < 2) {
          if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
              }
            }
          }
        } else if (selectedPiece.coordinate.y > 5) {
          if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
              }
            }
          }
        } else {
          if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'b') {
                attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
              }
            }
          }
          if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'b') {
                attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
              }
            }
          }
        }
      } else {
        if (selectedPiece.coordinate.y < 1) {
          if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
            moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
          }
        } else if (selectedPiece.coordinate.y > 6) {
          if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
            moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
          }
        } else {
          if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
            moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
          }
          if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
            moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
          }
        }
      }
    }
  } else {
    if (selectedPiece.kingMe == true) {
      if (possibleAttacks.size() > 0) {
        if (selectedPiece.coordinate.x < 2) {
          if (selectedPiece.coordinate.y < 2) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
          } else if (selectedPiece.coordinate.y > 5) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          }
        } else if (selectedPiece.coordinate.x > 5) {
          if (selectedPiece.coordinate.y < 2) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
          } else if (selectedPiece.coordinate.y > 5) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          }
        } else {
          if (selectedPiece.coordinate.y < 2) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
          } else if (selectedPiece.coordinate.y > 5) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
                if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                  attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
                }
              }
            }
          }
        }
      } else {
        if (selectedPiece.coordinate.x < 1) {
          if (selectedPiece.coordinate.y < 1) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
            }
          } else if (selectedPiece.coordinate.y > 6) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
            }
          }
        } else if (selectedPiece.coordinate.x > 6) {
          if (selectedPiece.coordinate.y < 1) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
            }
          } else if (selectedPiece.coordinate.y > 6) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
            }
          }
        } else {
          if (selectedPiece.coordinate.y < 1) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
            }
          } else if (selectedPiece.coordinate.y > 6) {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
            }
          } else {
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) + 1][int(selectedPiece.coordinate.y) - 1]);
            }
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
              moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
            }
          }
        }
      }
    } else {
      if (possibleAttacks.size() > 0) {
        if (selectedPiece.coordinate.y < 2) {
          if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
              }
            }
          }
        } else if (selectedPiece.coordinate.y > 5) {
          if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
              }
            }
          }
        } else {
          if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2].occupiedState == false) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == true) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].teamOccupying == 'r') {
                attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) + 2]);
              }
            }
          }
          if (board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2].occupiedState == false) {
            if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == true) {
              if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].teamOccupying == 'r') {
                attackSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 2][int(selectedPiece.coordinate.y) - 2]);
              }
            }
          }
        }
      } else {
        if (selectedPiece.coordinate.y < 1) {
          if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
            moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
          }
        } else if (selectedPiece.coordinate.y > 6) {
          if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
            moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
          }
        } else {
          if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1].occupiedState == false) {
            moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) + 1]);
          }
          if (board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1].occupiedState == false) {
            moveSquares.add(board.squareList[int(selectedPiece.coordinate.x) - 1][int(selectedPiece.coordinate.y) - 1]);
          }
        }
      }
    }
  }
  if (possibleAttacks.size() > 0) {
    for (int x = 0; x < attackSquares.size(); x++) {
      attackSquares.get(x).colourOfSquare = 'g';
    }
  } else {
    for (int x = 0; x < moveSquares.size(); x++) {
      moveSquares.get(x).colourOfSquare = 'u';
    }
  }
}

//checks if you've clicked on a valid move space, then moves the selected checkerPiece there
void chooseMove() {
  if (possibleAttacks.size() > 0) {
    for (int x = 0; x < attackSquares.size(); x++) {
      if ((mouseX>=(attackSquares.get(x).coordinate.x * 70) + 120)&&(mouseX<=(attackSquares.get(x).coordinate.x * 70) + 190)) {
        if ((mouseY>=(attackSquares.get(x).coordinate.y * 70) + 20)&&(mouseY<=(attackSquares.get(x).coordinate.y * 70) + 90)) {

          if (teamTurn == 'r') {
            for (int y = 0; y < blackTeam.length; y++) {
              if (blackTeam[y].coordinate.x == (selectedPiece.coordinate.x + attackSquares.get(x).coordinate.x)/2) {
                if (blackTeam[y].coordinate.y == (selectedPiece.coordinate.y + attackSquares.get(x).coordinate.y)/2) {
                  blackTeam[y].inPlay = false;
                  blackTeam[y].coordinate = new PVector(100, 100);
                }
              }
            }
          } else {
            for (int y = 0; y < redTeam.length; y++) {
              if (redTeam[y].coordinate.x == (selectedPiece.coordinate.x + attackSquares.get(x).coordinate.x)/2) {
                if (redTeam[y].coordinate.y == (selectedPiece.coordinate.y + attackSquares.get(x).coordinate.y)/2) {
                  redTeam[y].inPlay = false;
                  redTeam[y].coordinate = new PVector(100, 100);
                }
              }
            }
          }
          selectedPiece.coordinate = attackSquares.get(x).coordinate;
          moveChosen = true;
        }
      }
    }
  } else {
    for (int x = 0; x < moveSquares.size(); x++) {
      if ((mouseX>=((moveSquares.get(x).coordinate.x * 70) + 120))&&(mouseX<=((moveSquares.get(x).coordinate.x * 70) + 190))) {
        if ((mouseY>=((moveSquares.get(x).coordinate.y * 70) + 20))&&(mouseY<=((moveSquares.get(x).coordinate.y * 70) + 90))) {
          selectedPiece.coordinate = moveSquares.get(x).coordinate;
          moveChosen = true;
        }
      }
    }
  }
  //if you made a move
  if (moveChosen) {
    //reset board colours
    board = new CheckerBoard();
  }
}