//"In this Corner, Weighing in at 7 pounds, IS..."
class Cutter
{
  //Position
  PVector pos=new PVector();
  //Velocity
  PVector vel=new PVector();
  //Booleans for battling
  boolean pickedUp=false;
  boolean alive=false;
  boolean hit=false;
  //figuring out placements
  float tempPosX;
  float tempPosY;
  //health
  int health = 200;
  //Damage Dealt
  float dmgDealt;

  //This is to draw Cutter
  void make(float posX, float posY)
  {
    fill(0, 0, 180);
    noStroke();
    ellipseMode(CENTER);
    //Blades
    triangle(posX-20, posY-40, posX+5, posY-35, posX, posY);
    triangle(posX+40, posY-20, posX+35, posY+5, posX, posY);
    triangle(posX+20, posY+40, posX-5, posY+35, posX, posY);
    triangle(posX-40, posY+20, posX-35, posY-5, posX, posY);
    ellipse(posX, posY, 50, 50);
    fill(60);
    ellipse(posX, posY, 30, 30);
    fill(0, 0, 180);
    ellipse(posX, posY, 20, 20);
    fill(255);
    //show user who's winning
    text("HP:"+health, 270, 320);
  }

  //Shows Cutter to user
  void display()
  {
    make(300, 350);
    //If Cutter loses all health, it disappears
    if (health <=0)
    {
      pos.x=100;
      pos.y=500;
      alive=false;
    } 
    if (health>0&&alive==true)
    {
      make(pos.x, pos.y);
    }
    //resets Cutter's health
    if (keyPressed)
    {
      if (key==' ')
      {
        health=200;
      }
    }
  }
  //Cutter's movement 
  void move()
  {
    if (alive==true)
    {
      pos.x+=vel.x;
      pos.y+=vel.y;
    }
    //Wall Collision
    if (pos.x>=375||pos.x<=25)
    {
      vel.x *= -1;
    }

    if (pos.y>=275||pos.y<=25)
    {
      vel.y *= -1;
    }
  }

  //Credit to Jessica Olesky's Sweet Tea
  //Picking up Cutter
  void pickCutter() 
  {
    //If the mouse is above Cutter, the user can pick up Cutter
    if ((mouseX>275)&&(mouseX<325)&&(mouseY<375)&&(mouseY>325)&&(mousePressed==true)&&(pickedUp==false)&&(alive==false)) 
    {
      pickedUp= true;
    }
  }
  //When Cutter is picked up, it is on mouse's position
  void cutterMouse() 
  {
    if (pickedUp==true) 
    {
      make(mouseX, mouseY);
    }
  }
  //places Cutter down on the mouse's position, and says it is "alive"
  boolean placeCutter(float posX, float posY) 
  {
    if ((pickedUp==true)&&(mouseY<300)&&(mousePressed)) 
    {
      pickedUp= false;
      alive=true;
      health=200;

      pos.x=300;
      pos.y=200;

      vel.x=random(5, 9);
      vel.y=vel.x/2;
    }
    return alive;
  }
  //help calculating mouseX position
  float spawnCutterX()
  {
    if (alive==true)
    {
      tempPosX=mouseX;
    }
    return tempPosX;
  }
  //help calculating mouseY position
  float spawnCutterY()
  {
    if (alive==true)
    {
      tempPosY=mouseY;
    }
    return tempPosY;
  }
  //When Cutter is attacked by Stabby
  void defend(float hitTaken)
  {
    health-=hitTaken;
    hit=true;
  }
  //When Cutter attacks Stabby
  float attack()
  {
    if (hit==true)
    {
      dmgDealt=random(1, 5);
      hit=false;
    }
    return dmgDealt;
  }
  //returns Cutter's location
  PVector location()
  {
    return pos;
  }
}