/* Background class
 * Pieces of scrolling background; will constantly scroll downwards, moving above screen after passing bottom edge
 */

class Background {
  float y; //y position
  int col; //colour

  Background(float yPos) {
    y = yPos; //set initial y position
    col = 0;
  }

  //update function
  void update() {
    y += 3; //move down 3 pixels every frame
    col += 1; //change hue 1 unit every frame
    //move back to top once it passes bottom
    if (y == 600) {
      y = -600;
    }
    if (col == 360) {
      col = 0;
    }
  }
  
  //display function
  void display() {
    strokeWeight(1);
    stroke(col, 100, 100);
    noFill();

    for (int i = 0; i < 3; i++) {
      for (int j = 0; j < 5; j++) {
        rect(j*200, y+i*300, 50, 50);
      }
    }
    for (int i = 0; i < 3; i++) {
      ellipse(i*400, y+150, 50, 50);
    }
    for (int i = 0; i < 3; i++) {
      ellipse(i*400, y+450, 50, 50);
    }
    for (int i = 0; i < 2; i++) {
      rect(i*400+200, y+150, 50, 50);
    }
    for (int i = 0; i < 2; i++) {
      rect(i*400+200, y+450, 50, 50);
    }

    for (int i = 0; i < 3; i++) {
      for (int j = 0; j < 2; j++) {
        quad(j*400+200, y+i*300-100, j*400+300, y+i*300, j*400+200, y+i*300+100, j*400+100, y+i*300);
      }
    }
    for (int i = 0; i < 3; i++) {
      ellipse(i*400, y+150, 200, 200);
    }
    for (int i = 0; i < 3; i++) {
      ellipse(i*400, y+450, 200, 200);
    }
    
    for (int i = 0; i < 3; i++) {
      for (int j = 0; j < 2; j++) {
        line(j*400+200-50, y+i*300-50, j*400+200-25, y+i*300-25);
        line(j*400+200+50, y+i*300-50, j*400+200+25, y+i*300-25);
        line(j*400+200-50, y+i*300+50, j*400+200-25, y+i*300+25);
        line(j*400+200+50, y+i*300+50, j*400+200+25, y+i*300+25);
      }
    }
    for (int i = 0; i < 2; i++) {
      for (int j = 0; j < 2; j++) {
        line(j*400+200, y+i*300+150-50, j*400+200, y+i*300+150-25);
        line(j*400+200+100, y+i*300+150, j*400+200+25, y+i*300+150);
        line(j*400+200, y+i*300+150+50, j*400+200, y+i*300+150+25);
        line(j*400+200-100, y+i*300+150, j*400+200-25, y+i*300+150);
      }
    }
    for (int i = 0; i < 3; i++) {
      for (int j = 0; j < 2; j++) {
        line(j*400+25, y+i*300, j*400+100, y+i*300);
        line(j*400+300, y+i*300, j*400+375, y+i*300);
      }
    }
    for (int i = 0; i < 2; i++) {
      for (int j = 0; j < 2; j++) {
        line(j*400+200-175, y+i*300+150-125, j*400+200-25, y+i*300+150-25);
        line(j*400+200+175, y+i*300+150-125, j*400+200+25, y+i*300+150-25);
        line(j*400+200-175, y+i*300+150+125, j*400+200-25, y+i*300+150+25);
        line(j*400+200+175, y+i*300+150+125, j*400+200+25, y+i*300+150+25);
      }
    }
  }
}