/* Enemy class
 * The enemy boss; moves around shooting bullet patterns, and can be hit by player bullets; is destroyed when its health reaches 0
 */

class Enemy {

  PVector pos; //position vector
  int hp; //health/hitpoints
  int pType; //pattern type
  int timer, pTimer; //timer & pattern timer
  int glow; //glow timer
  int col; //colour
  float calcNum1, calcNum2; //numbers used for various values in bullet patterns (e.g. angle, velocity)
  boolean dead; //is enemy dead?
  
  //initialize all variables
  Enemy() {
    pos = new PVector(400, 120);
    hp = 0;
    pType = 0;
    timer = -120; //equivalent to 2 seconds of startup animation
    pTimer = 0;
    glow = 0;
    calcNum1 = 0;
    calcNum2 = 0;
    dead = false;
  }

  //update function
  void update() {
    if (!dead) {
      timer += 1; //increment timer

      if (timer <= 0) { //startup animation
        hp = (int)((120+timer)*30); //increase hp along with timer
        col = (int)(0.05*hp); //colour corresponds to hp
      } else { //in battle
        //when hp drops below certain points (every 450 hp lost)
        if (hp <= 3600-(pType+1)*450) { 
          pType += 1; //switch to next pattern
          hp = 3600-pType*450;
          pTimer = 0;
          //destroy all enemy bullets
          for (EnemyBullet i : enemyBullet) {
            if (!i.destroyed) {
              i.destroyed = true;
            }
          }
          spawnParticle(pos.x, pos.y, 3, 0, 0);
        }
        //decrement glow timer
        if (glow > 0) {
          glow -= 1;
        }
        //colour corresponds to hp
        col = (int)(0.05*hp);
        //move enemy boss along figure 8 path
        pos.x = wave(400, 960, 200, timer);
        pos.y = wave(120, 480, 40, timer);

        pattern(); //call bullet pattern function
      }
      //detect enemy boss/player bullet collision
      for (PlayerBullet i : playerBullet) {
        if (pos.dist(i.pos) < 45 && !i.destroyed) { //if collided
          if (timer > 0) {
            //decrement health and set glow to last 2 frames
            hp -= 1;
            glow = 2;
          }
          //destroy collided player bullet
          i.destroyed = true;
          i.lifeTime = 0;
        }
      }
    }
  }
  
  //display function
  void display() {
    if (!dead) {
      if (timer <= 0) { //startup animation
        //draw enemy boss
        noStroke();
        fill(col, 100, 100, wave(wave(0, 480, 75, timer+120), 120, -15, frameCount));
        ellipse(pos.x, pos.y, wave(wave(0, 480, 100, timer+120), 120, 5, frameCount), wave(wave(0, 480, 100, timer+120), 120, 5, frameCount));
        fill(col, 25, 100, wave(0, 480, 50, timer+120));
        quad(pos.x-28.284, pos.y-28.284, rotateX(pos.x-80, pos.y-70, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateY(pos.x-80, pos.y-70, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateX(pos.x-150, pos.y-80, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateY(pos.x-150, pos.y-80, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateX(pos.x-100, pos.y, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateY(pos.x-100, pos.y, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)));
        triangle(pos.x-40, pos.y, rotateX(pos.x-90, pos.y+20, pos.x-40, pos.y, wave(0, 120, 15, frameCount-15)), rotateY(pos.x-90, pos.y+20, pos.x-40, pos.y, wave(0, 120, 15, frameCount-15)), rotateX(pos.x-100, pos.y+80, pos.x-40, pos.y, wave(0, 120, 15, frameCount-15)), rotateY(pos.x-100, pos.y+80, pos.x-40, pos.y, wave(0, 120, 15, frameCount-15)));
        quad(pos.x+28.284, pos.y-28.284, rotateX(pos.x+80, pos.y-70, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateY(pos.x+80, pos.y-70, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateX(pos.x+150, pos.y-80, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateY(pos.x+150, pos.y-80, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateX(pos.x+100, pos.y, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateY(pos.x+100, pos.y, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)));
        triangle(pos.x+40, pos.y, rotateX(pos.x+90, pos.y+20, pos.x+40, pos.y, wave(0, 120, -15, frameCount-15)), rotateY(pos.x+90, pos.y+20, pos.x+40, pos.y, wave(0, 120, -15, frameCount-15)), rotateX(pos.x+100, pos.y+80, pos.x+40, pos.y, wave(0, 120, -15, frameCount-15)), rotateY(pos.x+100, pos.y+80, pos.x+40, pos.y, wave(0, 120, -15, frameCount-15)));
        fill(0, 0, 100, wave(0, 480, 100, timer+120));
        ellipse(pos.x, pos.y, wave(0, 480, 80, timer+120), wave(0, 480, 80, timer+120));

        //draw enemy health bar (circular)
        noFill();
        strokeWeight(3);
        stroke(0, 0, 100);
        strokeCap(SQUARE);
        arc(pos.x, pos.y, 160, 160, -PI/2+(PI*(float)(3600-hp)/1800), 3*PI/2);
        strokeCap(ROUND);
      } else { //in battle
        //draw enemy boss
        noStroke();
        fill(col, 100, 100, wave(75, 120, -15, frameCount));
        ellipse(pos.x, pos.y, wave(100, 120, 5, frameCount), wave(100, 120, 5, frameCount));
        fill(col, 25, 100, 50);
        quad(pos.x-28.284, pos.y-28.284, rotateX(pos.x-80, pos.y-70, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateY(pos.x-80, pos.y-70, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateX(pos.x-150, pos.y-80, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateY(pos.x-150, pos.y-80, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateX(pos.x-100, pos.y, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)), rotateY(pos.x-100, pos.y, pos.x-28.284, pos.y-28.284, wave(0, 120, 15, frameCount)));
        triangle(pos.x-40, pos.y, rotateX(pos.x-90, pos.y+20, pos.x-40, pos.y, wave(0, 120, 15, frameCount-15)), rotateY(pos.x-90, pos.y+20, pos.x-40, pos.y, wave(0, 120, 15, frameCount-15)), rotateX(pos.x-100, pos.y+80, pos.x-40, pos.y, wave(0, 120, 15, frameCount-15)), rotateY(pos.x-100, pos.y+80, pos.x-40, pos.y, wave(0, 120, 15, frameCount-15)));
        quad(pos.x+28.284, pos.y-28.284, rotateX(pos.x+80, pos.y-70, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateY(pos.x+80, pos.y-70, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateX(pos.x+150, pos.y-80, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateY(pos.x+150, pos.y-80, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateX(pos.x+100, pos.y, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)), rotateY(pos.x+100, pos.y, pos.x+28.284, pos.y-28.284, wave(0, 120, -15, frameCount)));
        triangle(pos.x+40, pos.y, rotateX(pos.x+90, pos.y+20, pos.x+40, pos.y, wave(0, 120, -15, frameCount-15)), rotateY(pos.x+90, pos.y+20, pos.x+40, pos.y, wave(0, 120, -15, frameCount-15)), rotateX(pos.x+100, pos.y+80, pos.x+40, pos.y, wave(0, 120, -15, frameCount-15)), rotateY(pos.x+100, pos.y+80, pos.x+40, pos.y, wave(0, 120, -15, frameCount-15)));
        //yin-yang; will glow brighter when enemy hit
        fill(0, 0, 100);
        ellipse(pos.x, pos.y, 80, 80);
        fill(col, 50-glow*25, 100);
        arc(pos.x, pos.y, 80, 80, PI/2+(float)frameCount/60*PI, 3*PI/2+(float)frameCount/60*PI);
        ellipse(rotateX(pos.x, pos.y-20, pos.x, pos.y, degrees((float)frameCount/60*PI)), rotateY(pos.x, pos.y-20, pos.x, pos.y, degrees((float)frameCount/60*PI)), 40, 40);
        fill(0, 0, 100);
        ellipse(rotateX(pos.x, pos.y+20, pos.x, pos.y, degrees((float)frameCount/60*PI)), rotateY(pos.x, pos.y+20, pos.x, pos.y, degrees((float)frameCount/60*PI)), 40, 40);
        ellipse(rotateX(pos.x, pos.y-20, pos.x, pos.y, degrees((float)frameCount/60*PI)), rotateY(pos.x, pos.y-20, pos.x, pos.y, degrees((float)frameCount/60*PI)), 10, 10);
        fill(col, 50-glow*25, 100);
        ellipse(rotateX(pos.x, pos.y+20, pos.x, pos.y, degrees((float)frameCount/60*PI)), rotateY(pos.x, pos.y+20, pos.x, pos.y, degrees((float)frameCount/60*PI)), 10, 10);
        
        //draw enemy health bar (circular)
        noFill();
        strokeWeight(3);
        stroke(0, 0, 100);
        strokeCap(SQUARE);
        arc(pos.x, pos.y, 160, 160, -PI/2+(PI*(float)(3600-hp)/1800), 3*PI/2);
        strokeCap(ROUND);
      }
    }
  }
  
  //enemy bullet pattern function; bullets determined by current pattern
  void pattern() {
    if (pType == 0) { //rapidly fire 2 expanding rings of bullets with different speeds; one ring accelerates
      if (pTimer == 0) {
        calcNum1 = 90;
      }
      if (pTimer % 20 == 0) { //every 20 frames
        for (int i = 0; i < 10; i++) { //10 bullets per ring
          spawnBullet(pos.x, pos.y, 30, 0, calcNum1+i*36, 4, 3, 0, 0);
          spawnBullet(pos.x, pos.y, 20, 60, -calcNum1-18-i*36, 0, 6, 0.05, 0);
        }
        calcNum1 += 10;
      }
    }
    if (pType == 1) { //rapidly fire 2 expanding rings of bullets with different speeds from a point near the enemy
      if (pTimer % 20 == 0) { //every 20 frames
        float tempX = random(pos.x-100, pos.x+100);
        float tempY = random(pos.y-100, pos.y+100);
        calcNum1 = random(0, 30);
        for (int i = 0; i < 12; i++) { //12 bullets per ring
          spawnBullet(tempX, tempY, 20, 120, calcNum1+i*30, 4, 4, 0, 0);
          spawnBullet(tempX, tempY, 10, 180, calcNum1+i*30, 2, 2, 0, 0);
        }
      }
    }
    if (pType == 2) { //randomly fire lines of accelerating bullets that linger
      if (pTimer % 10 == 0) { //every 10 frames
        calcNum1 = random(angle(pos.x, pos.y, player.pos.x, player.pos.y)-120, angle(pos.x, pos.y, player.pos.x, player.pos.y)+120);
        for (int i = 1; i < 9; i++) { //9 bullets per line
          spawnBullet(pos.x, pos.y, 20, 240, calcNum1, 0, i, (float)i/30, 15);
        }
      }
    }
    if (pType == 3) { //fire 4 turning streams of bullets with varying spread, forming both spread-out and condensed formations
      if (pTimer == 0) {
        calcNum1 = 90;
        calcNum2 = 0;
      }
      if (pTimer % 2 == 0) { //every 2 frames
        for (int i = 0; i < 4; i++) { //4 bullets
          spawnBullet(pos.x, pos.y, 10, 300, calcNum1+i*90, 4, 4, 0, 0);
        }
        calcNum2 += 0.5;
        calcNum1 += calcNum2;
      }
    }
    if (pType == 4) { //fire 3 turning streams of bullets and less often, 4 giant slow bullets
      if (pTimer == 0) {
        calcNum1 = 90;
        calcNum2 = 90;
      }
      if (pTimer % 30 == 0) { //every 30 frames
        for (int i = 0; i < 4; i++) { //4 bullets
          spawnBullet(pos.x, pos.y, 90, 60, calcNum1+i*90, 0, 2, 0.01, 30);
        }
        calcNum1 += 25;
      }
      if (pTimer % 2 == 0) { //every 2 frames
        for (int i = 0; i < 3; i++) { //3 bullets
          spawnBullet(pos.x, pos.y, 10, 0, calcNum2+i*120, 3, 3, 0, 0);
        }
        calcNum2 -= 6;
      }
    }
    if (pType == 5) { //fire 10 condensed streams of bullets with breaks for player to pass through
      if (pTimer == 0) {
        calcNum1 = 90;
        calcNum2 = 90;
      }
      if (pTimer % 60 >= 0 && pTimer % 60 < 45 && pTimer % 2 == 0) { //every 2 frames, with a break every 60 frames lasting 15 frames
        for (int i = 0; i < 4; i++) { //4 bullets
          spawnBullet(pos.x, pos.y, 20, 120, calcNum1+i*90, 0, 8, 0.05, 0);
        }
      }
      if (pTimer % 2 == 0) { //
        calcNum1 -= 2;
      }
      if (pTimer % 40 >= 0 && pTimer % 40 < 20 && pTimer % 2 == 0) { //every 2 frames, with a break every 40 frames lasting 20 frames
        for (int i = 0; i < 6; i++) { //6 bullets
          spawnBullet(pos.x, pos.y, 10, 180, calcNum2+i*60, 4, 4, 0, 0);
        }
        calcNum2 += 1.5;
      }
    }
    if (pType == 6) { //fire 2 lines of accelerating bullets while firing a stream of bullets aimed at the player with varying velocity
      if (pTimer == 0) {
        calcNum1 = 0;
      }
      if (pTimer % 10 == 0) { //every 10 frames
        for (int i = 1; i < 5; i++) { //5 bullets per line
          spawnBullet(pos.x+100, pos.y, 10, 240, calcNum1, i, i, 0, 0);
          spawnBullet(pos.x-100, pos.y, 10, 240, 180-calcNum1, i, i, 0, 0);
        }
        calcNum1 += 7;
        calcNum2 = wave(3, 360, 2, pTimer);
        spawnBullet(pos.x, pos.y, 20, 300, angle(pos.x, pos.y, player.pos.x, player.pos.y), calcNum2, calcNum2, 0, 0); //1 aimed bullet
      }
    }
    if (pType == 7) { //rapidly and randomly fire randomly coloured bullets with random sizes in random directions at random speeds
      if (pTimer % 1 == 0) { //every frame
        float tempVel = random(1, 6);
        //2 bullets
        spawnBullet(pos.x, pos.y, 10*(int)random(1, 4), 60*(int)random(0, 6), random(0, 360), tempVel, tempVel, 0.1, 0);
        spawnBullet(pos.x, pos.y, 10*(int)random(1, 4), 60*(int)random(0, 6), random(0, 360), tempVel, tempVel, 0.1, 0);
      }
    }
    pTimer += 1;
  }
  
  //spawn an enemy bullet object with the following parameters: x position, y position, size, colour, direction, velocity, maximum velocity, acceleration, acceleration delay
  void spawnBullet(float x, float y, float s, int c, float d, float v, float mv, float a, int ad) {
    boolean recycle = false;
    //check for unused enemy bullet objects and recycle if available
    for (EnemyBullet i : enemyBullet) {
      if (i.unused) {
        i.recycle(x, y, s, c, d, v, mv, a, ad);
        recycle = true;
        break;
      }
    }
    //create new enemy bullet object if no available unused objects
    if (!recycle) {
      enemyBullet.add(new EnemyBullet(x, y, s, c, d, v, mv, a, ad));
    }
  }

  //function used for sine wave based animations; adjustable base value, period in frames, and amplitude
  float wave(float base, float period, float amp, int input) { 
    return(base+amp*sin(PI/(period/2)*input));
  }

  //function used for calculating a point's X position after rotating around another point a specified number of degrees
  float rotateX(float pointX, float pointY, float originX, float originY, float degrees) {
    return(originX+(pointX-originX)*cos(radians(degrees))-(pointY-originY)*sin(radians(degrees)));
  }

  //same as above but for Y position
  float rotateY(float pointX, float pointY, float originX, float originY, float degrees) {
    return(originY+(pointY-originY)*cos(radians(degrees))+(pointX-originX)*sin(radians(degrees)));
  }

  //function used to find the angle from one point to another point
  float angle(float x1, float y1, float x2, float y2) {
    float a = degrees(atan((y2-y1)/(x2-x1)));
    if (x1 <= x2) {
      return(a);
    } else {
      return(a+180);
    }
  }
}