/* EnemyBullet class
 * Enemy bullets; spawned by the enemy boss, will kill the player upon collision; highly customizable
 */

class EnemyBullet {

  PVector pos; //position vector
  PVector dir; //direction vector
  float bulletSize; //bullet size
  float vel; //velocity
  float mVel; //maximum velocity
  float accel; //acceleration
  int timer; //timer
  int delay; //delay timer
  int col; //colour
  boolean destroyed=false; //is bullet destroyed?
  boolean unused; //is bullet object unused?

  //initialize all variables; parameters: x position, y position, size, colour, direction, velocity, maximum velocity, acceleration, acceleration delay
  EnemyBullet(float x, float y, float s, int c, float d, float v, float mv, float a, int ad) {
    pos = new PVector(x, y);
    dir = PVector.fromAngle(radians(d));
    bulletSize = s;
    vel = v;
    mVel = mv;
    accel = a;
    delay = ad;
    col = c % 360;
    timer = -15;
    destroyed = false;
    unused = false;
  }

  //identical to constructor but for recycled objects
  void recycle(float x, float y, float s, int c, float d, float v, float mv, float a, int ad) {
    pos.set(x, y);
    dir = PVector.fromAngle(radians(d));
    bulletSize = s;
    vel = v;
    mVel = mv;
    accel = a;
    delay = ad;
    col = c % 360;
    timer = -15;
    destroyed = false;
    unused = false;
  }

  //update function
  void update() {
    if (!destroyed) {
      //startup animation
      if (timer < 0) {
        timer += 1;
      } else { //bullet active
        //delay timer ended
        if (delay == 0) {
          vel += accel; //accelerate
          if (vel > mVel) {
            vel = mVel;
          }
          dir.setMag(vel);
          pos.add(dir); //move bullet
        } else {
          delay -= 1; //decrement delay timer if still active
        }
        //check if off-screen
        if ((pos.x < -bulletSize/2 || pos.x > 800+bulletSize/2 || pos.y < -bulletSize/2 || pos.y > 600+bulletSize/2) && !destroyed) {
          destroyed = true;
          unused = true;
        }
      }
    } else { //bullet destroyed
      timer += 1;
      //delay timer ended
      if (delay == 0) {
        vel += accel; //accelerate
        if (vel > mVel) {
          vel = mVel;
        }
      } else {
        delay -= 1; //decrement delay timer if still active
      }
      dir.setMag(vel);
      pos.add(dir); //move bullet
      //set to unused if destroyed for 15 frames
      if (timer == 15) {
        unused = true;
      }
    }
  }
  
  //display function
  void display() {
    if (!destroyed) {
      //startup animation
      if (timer < 0) {
        noStroke();
        fill(0, 0, 100, 100+(float)timer*6.666);
        ellipse(pos.x, pos.y, bulletSize-(timer*bulletSize/15), bulletSize-(timer*bulletSize/15));
      } else {
        //draw bullet
        strokeWeight(1+bulletSize/10);
        stroke(col, 100, 100);
        fill(0, 0, 100);
        ellipse(pos.x, pos.y, bulletSize, bulletSize);
      }
    } else { //bullet destroyed
      //draw destroyed bullet
      strokeWeight((1+bulletSize/10)-timer*(1+bulletSize/10)/15);
      stroke(col, 100, 100, 100-timer/6.666);
      noFill();
      ellipse(pos.x, pos.y, bulletSize, bulletSize);
    }
  }
}