/* Particle class
 * Particles; used for visual effects, have no effect on gameplay
 */

class Particle {

  PVector pos; //position vector
  PVector dir; //direction vector
  int type; //particle type
  int timer; //timer
  float vel; //velocity
  boolean unused; //is particle object unused?

  //initialize all variables; parameters: x position, y position, type, direction, velocity
  Particle(float x, float y, int t, float d, float v) {
    pos = new PVector(x, y);
    vel = v;
    float angleInRadians=radians(d);
    dir = PVector.fromAngle(angleInRadians);
    dir.mult(vel);
    type = t;
    unused = false;
    timer = 0;
  }

  //identical to constructor but for recycled objects
  void recycle(float x, float y, int t, float d, float v) {
    pos.set(x, y);
    vel = v;
    float angleInRadians=radians(d);
    dir = PVector.fromAngle(angleInRadians);
    dir.mult(vel);
    type = t;
    unused = false;
    timer = 0;
  }

  //update function
  void update() {
    if (!unused) {
      pos.add(dir); //move particle
      if (type == 2) {
        timer += 1;
        if (timer == 100) { //disappears after 100 frames
          unused = true;
        }
      }
      if (type == 3) {
        timer += 1;
        if (timer == 30) { //disappears after 30 frames
          unused = true;
        }
      }
      //check if off-screen
      if (pos.x < -100 || pos.x > 900 || pos.y < -100 || pos.y > 700) {
        unused = true;
      }
    }
  }
  
  //display function
  void display() {
    if (!unused) {
      if (type == 1) { //star particle; small, translucent white circles moving downwards from top
        noStroke();
        fill(0, 0, 100, 25+vel*2);
        ellipse(pos.x, pos.y, vel, vel);
      }
      if (type == 2) { //explode particle; pulsating circles
        noStroke();
        fill(0, 0, 100, 100-timer);
        ellipse(pos.x, pos.y, wave((float)(100-timer), 10, (float)(100-timer)/2, timer), wave((float)(100-timer), 10, (float)(100-timer)/2, timer));
      }
      if (type == 3) { //blast particle; rapidly expanding circle that fades
        strokeWeight((float)(100-timer*3.333)/5);
        stroke(0, 0, 100);
        fill(0, 0, 100, 100-timer*3.333);
        ellipse(pos.x, pos.y, timer*40, timer*40);
      }
    }
  }

  //function used for sine wave based animations; adjustable base value, period in frames, and amplitude
  float wave(float base, float period, float amp, int input) { 
    return(base+amp*sin(PI/(period/2)*input));
  }
}