/* Player class
 * The player-controlled entity; can be moved and can fire player bullets
 */

class Player {

  PVector pos; //position vector
  PVector vel; //velocity vector
  int focusTimer; //focus timer for focus animation
  int fireTimer; //fire timer for firing intervals
  int timer; //timer
  int col; //colour
  int deaths; //number of deaths
  boolean right; //move right
  boolean left; //move left
  boolean down; //move down
  boolean up; //move up
  boolean focus; //focus mode
  boolean fire; //fire mode
  boolean dead=false; //is player dead?

  //initialize all variables
  Player() {
    pos = new PVector(400, 550);
    vel = new PVector(0, 0);
    focusTimer = 0;
    fireTimer = 0;
    timer = 60;
    col = 0;
    deaths = 0;
    focus = false;
    fire = false;
    dead = false;
  }

  //update function
  void update() {
    vel.set(0, 0);
    //change focus animation timer
    if (focusTimer > 0 && !focus) {
      focusTimer -= 1;
    } else if (focusTimer < 10 && focus) {
      focusTimer += 1;
    }
    //decrement firing timer
    if (fireTimer > 0) {
      fireTimer -= 1;
    }

    if (gameStart) {
      //detect player/enemy bullet collision
      for (EnemyBullet i : enemyBullet) {

        if (dist(player.pos.x, player.pos.y, i.pos.x, i.pos.y) < 5+i.bulletSize/2.-(1+i.bulletSize/10.)/2. && !dead && !i.destroyed) { //if collided


          dead = true; //die die die
          timer = -60;
          deaths += 1; //increment death counter
          noStroke();
          fill(0, 100, 100);
          rect(400, 300, 900, 700);
          for (int j = 0; j < 8; j++) { //explosion!
            spawnParticle(pos.x, pos.y, 2, j*45, 5);
          }
          spawnParticle(pos.x, pos.y, 3, 0, 0);
          pos = new PVector(400, 550); //reset position
        }
      }
      //detect player/enemy collision; same death sequence as above
      if (player.pos.dist(enemy.pos) < 45 && !dead && !enemy.dead && enemy.timer > 0) {
        dead = true;
        timer = -60;
        deaths += 1;
        noStroke();
        fill(0, 100, 100);
        rect(400, 300, 900, 700);
        for (int j = 0; j < 8; j++) {
          spawnParticle(pos.x, pos.y, 2, j*45, 5);
        }
        spawnParticle(pos.x, pos.y, 3, 0, 0);
        pos = new PVector(400, 550);
      }
    }

    if (!dead) {
      if (focus) { //focused
        //move 3 pixels in active direction
        if (right) { //move right
          vel.x += 3;
        }
        if (left) { //move left
          vel.x -= 3;
        }
        if (down) { //move down
          vel.y += 3;
        }
        if (up) { //move up
          vel.y -= 3;
        }
      } else { //unfocused
        //move 8 pixels in active direction
        if (right) { //move right
          vel.x += 8;
        }
        if (left) { //move left
          vel.x -= 8;
        }
        if (down) { //move down
          vel.y += 8;
        }
        if (up) { //move up
          vel.y -= 8;
        }
      }
      pos.add(vel); //move player
      //movement bounds; cannot pass screen edges
      if (pos.x < 20) {
        pos.x = 20;
      }
      if (pos.x > 780) {
        pos.x = 780;
      }
      if (pos.y < 20) {
        pos.y = 20;
      }
      if (pos.y > 580) {
        pos.y = 580;
      }

      //spawn 4 fast bullets moving upwards
      if (fire && fireTimer == 0) {
        spawnBullet(rotateX(pos.x, pos.y-50, pos.x, pos.y, -90+focusTimer*6), rotateY(pos.x, pos.y-50, pos.x, pos.y, -90+focusTimer*6), col);
        spawnBullet(rotateX(pos.x, pos.y-50, pos.x, pos.y, 90-focusTimer*6), rotateY(pos.x, pos.y-50, pos.x, pos.y, 90-focusTimer*6), col);
        spawnBullet(rotateX(pos.x, pos.y-50, pos.x, pos.y, -30+focusTimer*2), rotateY(pos.x, pos.y-50, pos.x, pos.y, -30+focusTimer*2), col);
        spawnBullet(rotateX(pos.x, pos.y-50, pos.x, pos.y, 30-focusTimer*2), rotateY(pos.x, pos.y-50, pos.x, pos.y, 30-focusTimer*2), col);
        fireTimer = 5; //may fire every 5 frames
      }
    } else {
      timer += 1;
      if (timer == 60) {
        //destroy all enemy bullets on respawn
        for (EnemyBullet i : enemyBullet) {
          i.destroyed = true;
        }
        dead = false;
        spawnParticle(pos.x, pos.y, 3, 0, 0);
      }
    }

    //change colour slightly every frame
    col += 1;
    if (col == 360) {
      col = 0;
    }
  }

  //display function
  void display() {
    if (timer >= 0) {
      noStroke();
      //draw bullet spawn points
      fill(col, 50-fireTimer*10, 100, wave(0, 240, 80+fireTimer*4, timer));
      ellipse(rotateX(pos.x, pos.y-50, pos.x, pos.y, -90+focusTimer*6), rotateY(pos.x, pos.y-50, pos.x, pos.y, -90+focusTimer*6), 10+fireTimer, 10+fireTimer);
      ellipse(rotateX(pos.x, pos.y-50, pos.x, pos.y, 90-focusTimer*6), rotateY(pos.x, pos.y-50, pos.x, pos.y, 90-focusTimer*6), 10+fireTimer, 10+fireTimer);
      ellipse(rotateX(pos.x, pos.y-50, pos.x, pos.y, -30+focusTimer*2), rotateY(pos.x, pos.y-50, pos.x, pos.y, -30+focusTimer*2), 10+fireTimer, 10+fireTimer);
      ellipse(rotateX(pos.x, pos.y-50, pos.x, pos.y, 30-focusTimer*2), rotateY(pos.x, pos.y-50, pos.x, pos.y, 30-focusTimer*2), 10+fireTimer, 10+fireTimer);
      //draw player
      fill(col, 100, 100, wave(wave(0, 240, 75, timer), 120, -15, frameCount));
      ellipse(pos.x, pos.y, wave(wave(0, 240, 35, timer), 120, 3, frameCount), wave(wave(0, 240, 35, timer), 120, 3, frameCount));
      fill(col, 25, 100, wave(0, 240, 50, timer));
      triangle(pos.x-14.142, pos.y-14.142, rotateX(pos.x-50, pos.y-30, pos.x-14.142, pos.y-14.142, wave(0, 120, 15, frameCount)), rotateY(pos.x-50, pos.y-30, pos.x-14.142, pos.y-14.142, wave(0, 120, 15, frameCount)), rotateX(pos.x-40, pos.y-10, pos.x-14.142, pos.y-14.142, wave(0, 120, 15, frameCount)), rotateY(pos.x-40, pos.y-10, pos.x-14.142, pos.y-14.142, wave(0, 120, 15, frameCount)));
      triangle(pos.x-20, pos.y, rotateX(pos.x-45, pos.y, pos.x-20, pos.y, wave(0, 120, 15, frameCount-10)), rotateY(pos.x-45, pos.y, pos.x-20, pos.y, wave(0, 120, 15, frameCount-10)), rotateX(pos.x-35, pos.y+10, pos.x-20, pos.y, wave(0, 120, 15, frameCount-10)), rotateY(pos.x-35, pos.y+10, pos.x-20, pos.y, wave(0, 120, 15, frameCount-10)));
      triangle(pos.x-14.142, pos.y+14.142, rotateX(pos.x-30, pos.y+20, pos.x-14.142, pos.y+14.142, wave(0, 120, 15, frameCount-20)), rotateY(pos.x-30, pos.y+20, pos.x-14.142, pos.y+14.142, wave(0, 120, 15, frameCount-20)), rotateX(pos.x-20, pos.y+25, pos.x-14.142, pos.y+14.142, wave(0, 120, 15, frameCount-20)), rotateY(pos.x-20, pos.y+25, pos.x-14.142, pos.y+14.142, wave(0, 120, 15, frameCount-20)));
      triangle(pos.x+14.142, pos.y-14.142, rotateX(pos.x+50, pos.y-30, pos.x+14.142, pos.y-14.142, wave(0, 120, -15, frameCount)), rotateY(pos.x+50, pos.y-30, pos.x+14.142, pos.y-14.142, wave(0, 120, -15, frameCount)), rotateX(pos.x+40, pos.y-10, pos.x+14.142, pos.y-14.142, wave(0, 120, -15, frameCount)), rotateY(pos.x+40, pos.y-10, pos.x+14.142, pos.y-14.142, wave(0, 120, -15, frameCount)));
      triangle(pos.x+20, pos.y, rotateX(pos.x+45, pos.y, pos.x+20, pos.y, wave(0, 120, -15, frameCount-10)), rotateY(pos.x+45, pos.y, pos.x+20, pos.y, wave(0, 120, -15, frameCount-10)), rotateX(pos.x+35, pos.y+10, pos.x+20, pos.y, wave(0, 120, -15, frameCount-10)), rotateY(pos.x+35, pos.y+10, pos.x+20, pos.y, wave(0, 120, -15, frameCount-10)));
      triangle(pos.x+14.142, pos.y+14.142, rotateX(pos.x+30, pos.y+20, pos.x+14.142, pos.y+14.142, wave(0, 120, -15, frameCount-20)), rotateY(pos.x+30, pos.y+20, pos.x+14.142, pos.y+14.142, wave(0, 120, -15, frameCount-20)), rotateX(pos.x+20, pos.y+25, pos.x+14.142, pos.y+14.142, wave(0, 120, -15, frameCount-20)), rotateY(pos.x+20, pos.y+25, pos.x+14.142, pos.y+14.142, wave(0, 120, -15, frameCount-20)));
      fill(0, 0, 100, wave(0, 240, 80, timer));
      ellipse(pos.x, pos.y, wave(0, 240, 30, timer), wave(0, 240, 30, timer));
      //draw hitbox
      fill(col, 100, 40, wave(0, 240, 100, timer));
      ellipse(pos.x, pos.y, 10, 10);
      fill(col, 100, 100, wave(0, 240, 100, timer));
      ellipse(pos.x, pos.y, 8, 8);
      fill(0, 0, 100, wave(0, 240, 100, timer));
      ellipse(pos.x, pos.y, wave(6, 120, 1, frameCount), wave(6, 120, 1, frameCount));
    }
  }

  //spawn a player bullet object with the following parameters: x position, y position, colour
  void spawnBullet(float x, float y, int c) {
    boolean recycle = false;
    //check for unused player bullet objects and recycle if available
    for (PlayerBullet i : playerBullet) {
      if (i.unused) {
        i.recycle(x, y, c);
        recycle = true;
        break;
      }
    }
    //create new player bullet object if no available unused objects
    if (!recycle) {
      playerBullet.add(new PlayerBullet(x, y, c));
    }
  }

  //function used for sine wave based animations; adjustable base value, period in frames, and amplitude
  float wave(float base, float period, float amp, int input) { 
    return(base+amp*sin(PI/(period/2)*input));
  }

  //function used for calculating a point's X position after rotating around another point a specified number of degrees
  float rotateX(float pointX, float pointY, float originX, float originY, float degrees) {
    return(originX+(pointX-originX)*cos(radians(degrees))-(pointY-originY)*sin(radians(degrees)));
  }

  //same as above but for Y position
  float rotateY(float pointX, float pointY, float originX, float originY, float degrees) {
    return(originY+(pointY-originY)*cos(radians(degrees))+(pointX-originX)*sin(radians(degrees)));
  }
}