/* PlayerBullet class
 * Player bullets; are fired from the player entity, and collide with the enemy boss to decrease its health
 */

class PlayerBullet {

  PVector pos; //position vector
  int lifeTime; //frames active
  int destroyTimer; //destroy timer
  int col; //colour
  boolean destroyed; //is bullet destroyed?
  boolean unused; //is bullet object unused?

  //initialize all variables; parameters: x position, y position, colour
  PlayerBullet(float x, float y, int c) {
    pos = new PVector();
    pos.set(x, y);
    lifeTime = 0;
    destroyTimer = 0;
    col = c;
    destroyed = false;
    unused = false;
  }

  //identical to constructor but for recycled objects
  void recycle(float x, float y, int c) {
    pos.set(x, y);
    lifeTime = 0;
    destroyTimer = 0;
    col = c;
    destroyed = false;
    unused = false;
  }

  //update function
  void update() {
    if (!destroyed) { //bullet active
      pos.y -= 30; //move up 30 pixels every frame
      lifeTime += 1;
      //check if offscreen
      if (pos.y < -100 && !destroyed) {
        destroyed = true;
        unused = true;
      }
    } else { //bullet destroyed
      destroyTimer += 1;
      //set to unused if destroyed for 15 frames
      if (destroyTimer == 15) {
        unused = true;
      }
    }
  }

  //display function
  void display() {
    if (!destroyed) { //bullet active
      //draw bullet; tail grows longer with time active
      noStroke();
      fill(col, 50, 100, 50);
      quad(pos.x, pos.y+5+lifeTime*4, pos.x-5, pos.y, pos.x, pos.y-5, pos.x+5, pos.y);
      fill(0, 0, 100);
      ellipse(pos.x, pos.y, 6, 6);
    } else { //bullet destroyed
      noStroke();
      fill(col, 50-(float)destroyTimer*3.333, 100, 50);
      //impact heightens and narrows
      quad(pos.x, pos.y+5, pos.x-(5-(float)destroyTimer*0.333), pos.y, pos.x, pos.y-5-destroyTimer*4, pos.x+(5-(float)destroyTimer*0.333), pos.y);
    }
  }
}