/* Tianyao Liu
 * Object-Oriented Toy: Bullet Rain
 * Intro to Media Computation
 *
 * Press Z to start the game.
 * Use Arrow Keys to move, Z to shoot, and Shift to focus.
 * Defeat the enemy while getting hit as little as possible.
 */


boolean gameStart = false; //has the boss been spawned?
Background[] scrollingBackground = new Background[2]; //scrolling background
Player player; //player character
Enemy enemy; //enemy boss
PFont font; //font object for death counter
ArrayList<PlayerBullet> playerBullet = new ArrayList<PlayerBullet>(); //player bullets
ArrayList<EnemyBullet> enemyBullet = new ArrayList<EnemyBullet>(); //enemy bullets
ArrayList<Particle> particle = new ArrayList<Particle>(); //particles

void setup() {
  size(800, 600);
  frameRate(60);
  noCursor();
  rectMode(CENTER);
  ellipseMode(CENTER);
  colorMode(HSB, 360, 100, 100, 100);

  player = new Player(); //create player
  font = createFont("Cirno.ttf", 30); //create font object
  textAlign(LEFT, TOP);
  textFont(font);
  textSize(30);
  
  //create backgrounds
  scrollingBackground[0] = new Background(-600);
  scrollingBackground[1] = new Background(0);
}

void draw() {
  background(0, 0, 0);
  //update backgrounds
  scrollingBackground[0].update();
  scrollingBackground[1].update();
  //display backgrounds
  scrollingBackground[0].display();
  scrollingBackground[1].display();

  //spawn star particle every 4 frames
  if (frameCount % 4 == 0) {
    spawnParticle(random(0, 800), -50, 1, 90, random(2, 11));
  }
  //update and display particles
  for (Particle i : particle) {
    if (!i.unused) {
      i.update();
      i.display();
    }
  }

  //update player
  player.update();
  //display player
  player.display();

  if (gameStart) {
    enemy.update(); //update enemy
    enemy.display(); //display enemy
    //update and display player bullets
    for (PlayerBullet i : playerBullet) {
      if (!i.unused) {
        i.update();
        i.display();
      }
    }
    //update and display enemy bullets
    for (EnemyBullet i : enemyBullet) {
      if (!i.unused) {
        i.update();
        i.display();
      }
    }

    noStroke();
    fill(0, 0, 100);
    text("DEATHS: "+player.deaths, 10, 10); //death counter
    
    //battle start animation for enemy
    if (enemy.timer == 0) {
      noStroke();
      fill(0, 0, 100);
      rect(400, 300, 900, 700);
      spawnParticle(enemy.pos.x, enemy.pos.y, 3, 0, 0);
    }
    //death animation for enemy
    if (!enemy.dead) {
      if (enemy.hp <= 0 && enemy.timer > 0) {
        enemy.dead = true;
        //destroy all enemy bullets
        for (EnemyBullet i : enemyBullet) {
          if (!i.destroyed) {
            i.destroyed = true;
          }
        }
        noStroke();
        fill(0, 0, 100);
        rect(400, 300, 900, 700);
        //explosion!
        for (int j = 0; j < 8; j++) {
          spawnParticle(enemy.pos.x, enemy.pos.y, 2, j*45, 5);
        }
        spawnParticle(enemy.pos.x, enemy.pos.y, 3, 0, 0);
      }
    }
  }
}

//spawn a particle object with the following parameters: x position, y position, type, direction, velocity
void spawnParticle(float x, float y, int t, float d, float v) {
  boolean recycle = false;
  //check for unused particle objects and recycle if available
  for (Particle i : particle) {
    if (i.unused) {
      i.recycle(x, y, t, d, v);
      recycle = true;
      break;
    }
  }
  //create new particle object if no available unused objects
  if (!recycle) {
    particle.add(new Particle(x, y, t, d, v));
  }
}

//key press events
void keyPressed() {
  if (keyCode == RIGHT && !player.right) { //move right
    player.right = true;
  }
  if (keyCode == LEFT && !player.left) { //move left
    player.left = true;
  }
  if (keyCode == DOWN && !player.down) { //move down
    player.down = true;
  }
  if (keyCode == UP && !player.up) { //move up
    player.up = true;
  }
  if (keyCode == SHIFT && !player.focus) { //focus
    player.focus = true;
  }
  if ((key == 'z' || key == 'Z') && !player.fire) { //fire
    player.fire = true;
    //pressing Z starts game
    if (!gameStart) {
      gameStart = true;
      enemy = new Enemy(); //create enemy boss
    }
  }
}

//key release events
void keyReleased() {
  if (keyCode == RIGHT && player.right) { //stop moving right
    player.right = false;
  }
  if (keyCode == LEFT && player.left) { //stop moving left
    player.left = false;
  }
  if (keyCode == DOWN && player.down) { //stop moving down
    player.down = false;
  }
  if (keyCode == UP && player.up) { //stop moving up
    player.up = false;
  }
  if (keyCode == SHIFT && player.focus) { //unfocus
    player.focus = false;
  }
  if ((key == 'z' || key == 'Z') && player.fire) { //stop firing
    player.fire = false;
  }
}