class Meteor {

  PVector position=new PVector();
  PVector velocity=new PVector();
  float meteorTop, meteorBottom, meteorLeft, meteorRight;
  float meteorSize; 
  float xTarget, yTarget;
  float rangeTimerStart, rangeTimerEnd;


//initializes each meteor
  Meteor() {
    init();
  }


//gives a velocity and position to each meteor
  void init() {
    noStroke();
    fill(100);

    //the meteors move fropm the center of the screen towards the sides as the rocket passes them
    velocity.x=random(-2.5, 2.5);
    velocity.y=random(-2.5, 2.5);
    position.x=300+10*velocity.x;
    position.y=300+10*velocity.y;
    
    //the red target area to dodge predects where the meteor will be in order to dodge
    xTarget = position.x+120*velocity.x;
    yTarget = position.y+120*velocity.y;
    meteorSize = 70+random(40);
    rangeTimerStart=millis();
  }


//updates the location of the meteors
  void update() {


    position.add(velocity);
    rangeTimerEnd = millis();

    //checks if the meteor reached the target area predicted 
    if (position.x>600 ||position.x<0 ||position.y>600 ||position.y<0 ||rangeTimerEnd-rangeTimerStart>2000||(xTarget==position.x && yTarget==position.y)) {
      meteorTop=yTarget-meteorSize/2; 
      meteorBottom=yTarget+meteorSize/2; 
      meteorLeft=xTarget-meteorSize/2; 
      meteorRight=xTarget+meteorSize/2;

      //checks if the rocket has collided with the meteor in the target area
      if ( sqrt(sq(yTarget-mouseY)+ sq(xTarget-mouseX))< meteorSize/2 ) {
        println("You got hit!");
      }

      //another meteor is initiated after the previous one hit the ship or passed it
      init();
    }
  }
  
  //function displays the meteors and their proper target area to dodge
  void display() {
    //using range timer to fade the meteors in vision as the rocket approaches them
    rangeTimerEnd = millis();
    
    //displays the meteors
    strokeWeight(1);
    stroke(0);
    fill(100, 100, 100, (rangeTimerEnd-rangeTimerStart)/2);
    ellipse( position.x, position.y, meteorSize, meteorSize);

  }



    //displays the target area where the meteor will pass the ship
  void target() {

    noStroke();
    fill(100, 0, 0, 85);
    ellipse( xTarget, yTarget, meteorSize, meteorSize);
  }
}