class Bullet {

  PVector position = new PVector(mainChar.position.x, mainChar.position.y);
  PVector velocity = new PVector(0, 0);
  //hit position
  PVector hitPos = new PVector();

  boolean exit = false;
  boolean control = true;
  boolean shot = false;
  boolean wallHit = false;

  //monster hit
  boolean monHit = false;


  int hitAnim = 0;

  void update() {
    // if the bullet hasn't left the chamber, then it's inside the player.
    if (exit == false || wallHit == true) {
      position.x = mainChar.position.x; 
      position.y = mainChar.position.y;
      control = true;
    } 
    //when you press space, the bullet exits. restricted by frame count so you dont shoot like crazy when you hold down space.
    if (playerShoot == true && shot == false &&frameCount% 15 ==0 && pDead == false) {
      exit = true;
    }

    // when the bullet exits:
    if (exit == true && wallHit == false) {
      //shoots bullet right if facing right. can no longer control the direction of the bullet based on where you are facing
      if (facingRight ==true &&control == true) {
        position.x = mainChar.position.x+15;
        velocity.x = abs(mainChar.velocity.x) +6;
        control = false;
        shot = true;
        //bullet left
      } else if (facingLeft ==true &&control == true) {
        position.x = mainChar.position.x-15;
        velocity.x =-abs(mainChar.velocity.x)-6;
        control = false;
        shot = true;
      }
    }

    //if bullet somehow exits the screen
    if (position.x > width || position.x < 0 && exit == true && shot == true) {
      position.x = mainChar.position.x; 
      position.y = mainChar.position.y;
      exit = false;
    } 

    //Controls bullet position
    position.add(velocity);
  }

  void hit() {
    //collision for Walls. If the bullet hit the wall, play the animation
    if (position.x + 5> rightWall.x1 || position.x - 5< leftWall.x2) {
      hitAnim = 1;
    }

    //platform collision for middle
    if (position.x -5 < middle.x2 && position.x +5 > middle.x1&& position.y-5< middle.y1 && position.y+5> middle.y2 && hitAnim ==0) {
      hitAnim = 1;
    }
    //mid2
    if (position.x -5 < mid2.x2 && position.x +5 > mid2.x1&& position.y-5< mid2.y1 && position.y+5> mid2.y2 && hitAnim ==0) {
      hitAnim = 1;
    }
    //mid3
    if (position.x -5 < mid3.x2 && position.x +5 > mid3.x1&& position.y-5< mid3.y1 && position.y+5> mid3.y2 && hitAnim ==0) {
      hitAnim = 1;
    }
    //mid4
    if (position.x -5 < mid4.x2 && position.x +5 > mid4.x1&& position.y-5< mid4.y1 && position.y+5> mid4.y2 && hitAnim ==0) {
      hitAnim = 1;
    }

    //bullet monster hit collision
    //numbers every monster, using i.
    for (int i =0; i<enemyNum; i++) {
      //checks the collision of every bullet and every enemy at once. if the bullet enters ANY enemy:
      if (pDead == false && e[i].bottomLeft.x <= position.x + 5 && e[i].topRight.x >= position.x - 5) {
        if (monHit == false && e[i].topRight.y - 15 <= position.y + 5 && e[i].bottomLeft.y >= position.y - 5) {
          //plays animation, enemyHP goes down
          velocity.x = 0;
          hitAnim = 1;
          e[i].hp--;
          monHit = true;
        }
      }
    }


    //bullet explosion animation
    if (hitAnim == 1) {
      wallHit = true;    
      hitAnim = 2;
      hitPos = position;
      fill( 255, 41, 41);
      rectMode (CENTER);
      rect (hitPos.x, hitPos.y, 25, 25);
    }
  }

  void display() {
    if (exit == true && wallHit == false) {
      fill( 255, 87, 41);
      rectMode (CENTER);
      rect (position.x, position.y, 10, 10);
    }
  }
}