class Enemy {

  PVector position= new PVector(width/2, 0);
  PVector bottomLeft = new PVector();
  PVector topRight = new PVector();
  PVector velocity= new PVector();
  PVector acceleration= new PVector();

  // determines which path the enemy takes
  int path;
  // which stage of the path the enemy is on
  int pathStage =1;
  int hp = 20;
  int monNum;


  float eGravity = 0.07;
  float speed;
  float radius = 12;
  boolean spawned = false;
  boolean dead;

//constructors for each enemy, speed, the path it takes, and the assigned # of each monster
  Enemy(float tempSpeed, int tempPath, int tempMonNum) {
    speed = tempSpeed;
    path = tempPath;
    monNum = tempMonNum;
  }


  void update() {
  // PVectors for the corners of the enemy, just to make things easier
    bottomLeft.x = position.x-radius;
    bottomLeft.y = position.y+radius;
    topRight.x = position.x+radius;
    topRight.y = position.y-radius;


    //death check
    if (hp <0) {
      spawned = false;
      dead = true;
      gs.score++;
      hp=3;
    }    

    //Spawning, counter is controlled by the spawner class
    if (spawner.counter== monNum && spawned == false) {
      position.y =0;
      spawned = true;
      //if hasn't spawned, stays off screen
    } else if (spawned == false|| dead == true) {
      position.y = -200;
      position.x = width/2;
      velocity.x = 0;
      velocity.y =0;
      acceleration.y =0;
    }


    //terminal horizontal velocity
    if (velocity.x >1.5) {
      velocity.x = 1.5*speed;
    } else if (velocity.x < -1.5) {
      velocity.x = -1.5*speed;
    }

    //horizontal movement controls
    //left spawn
    if (path ==1) {
      //when it hits the wall, go to stage 2
      if (bottomLeft.x < leftWall.x2) {
        pathStage = 2;
      }
      if (topRight.x > rightWall.x1) {
        pathStage = 4;
      }
      if (pathStage == 1) {
        acceleration.x = -0.5;
      } else if (pathStage == 2) {
        //turns around
        acceleration.x = 0.5;
      } else if (pathStage == 4) {
        acceleration.x = -0.5;
      }
    } 

    //left-right spawn
    if (path ==2) {
      if (bottomLeft.x < leftWall.x2) {
        pathStage = 2;
      }
      //when it reaches the center, reach stage 3
      if (topRight.x > width/2+50) {
        pathStage = 3;
      }
      if (pathStage == 1) {
        acceleration.x = -0.5;
      } else if (pathStage == 2) {
        acceleration.x = 0.5;
      } else if (pathStage == 3) {
        acceleration.x = -0.5;
      }
    }


    //right spawn
    if (path ==3) {
      if (bottomLeft.x < leftWall.x2) {
        pathStage = 2;
      }
      if (topRight.x > rightWall.x1) {
        pathStage = 4;
      }
      if (pathStage == 1) {
        acceleration.x = 0.5;
      } else if (pathStage == 2) {
        acceleration.x = 0.5;
      } else if (pathStage == 4) {
        acceleration.x = -0.5;
      }
    }
    //right-left spawn
    if (path ==4) {
      if (topRight.x > rightWall.x1) {
        pathStage = 2;
      }
      if (bottomLeft.x < width/2-50) {
        pathStage = 3;
      }
      if (pathStage == 1) {
        acceleration.x = 0.5;
      } else if (pathStage == 2) {
        acceleration.x = -0.5;
      } else if (pathStage == 3) {
        acceleration.x = 0.5;
      }
    }

    //vertical movement controls
    // controls collision based on which platform
    //for mid4
    if (bottomLeft.y> mid4.y2 && topRight.y < mid4.y1 && bottomLeft.x < mid4.x2 && topRight.x > mid4.x1) {
      position.y = mid4.y2 - radius;
      velocity.y = 0;
      acceleration.y=0;
    }
    //for mid3
    if (bottomLeft.y> mid3.y2 && topRight.y < mid3.y1 && bottomLeft.x < mid3.x2 && topRight.x > mid3.x1) {
      position.y = mid3.y2 - radius;
      velocity.y = 0;
      acceleration.y=0;
    }
    //for mid2
    if (bottomLeft.y> mid2.y2 && topRight.y < mid2.y1 && bottomLeft.x < mid2.x2 && topRight.x > mid2.x1) {
      position.y = mid2.y2 - radius;
      velocity.y = 0;
      acceleration.y=0;
    }
    //for middle
    if (bottomLeft.y> middle.y2 && topRight.y < middle.y1 && bottomLeft.x < middle.x2 && topRight.x > middle.x1) {
      position.y = middle.y2 - radius;
      velocity.y = 0;
      acceleration.y=0;
    }
    //for base1
    if (bottomLeft.y> base1.y2 && topRight.y < base1.y1 && bottomLeft.x < base1.x2 && topRight.x > base1.x1) {
      position.y = base1.y2 - radius;
      velocity.y = 0;
      acceleration.y=0;
    }
    //for base2
    if (bottomLeft.y> base2.y2 && topRight.y < base2.y1 && bottomLeft.x < base2.x2 && topRight.x > base2.x1) {
      position.y = base2.y2 - radius;
      velocity.y = 0;
      acceleration.y=0;
    }
    //as long as it's alive, it moves
    if (dead == false) {
      acceleration.y += eGravity;
      velocity.add(acceleration);
      position.add(velocity);
    }
  }

  void playerCollision() {
    //if enemy touches the player, you die
    if (mainChar.position.x - 15 <= position.x + radius && mainChar.position.x +15 >= position.x - radius) {

      if (mainChar.position.y - 15 <= position.y + radius && mainChar.position.y + 15 >= position.y - radius) {
        pDead = true;
      }
    }
  }

  void display() {

    fill(53, 129, 184);
    rectMode(CORNERS);
    if (dead == false) {
      rect (bottomLeft.x, bottomLeft.y, topRight.x, topRight.y);
    }
    //  noStroke();
  }
}