class Platform {

  float x1;
  float y1;
  float x2;
  float y2;

  int platformNum;



  Platform(float tempX1, float tempY1, float tempX2, float tempY2, int tempPlatformNum) {

    x1 = tempX1;
    y1 = tempY1;
    x2 = tempX2;
    y2 = tempY2;
    platformNum = tempPlatformNum;
  }

  void display() {
    rectMode(CORNERS);
    fill (50);
    rect (x1, y1, x2, y2);
  }

//if the player lands on top of the platform
  void collisionCheck() {
    if (mainChar.position.y > y2-mainChar.pHeight/2  && mainChar.position.x > x1 - mainChar.pWidth/2 && mainChar.position.x < x2 + mainChar.pWidth/2 && mainChar.position.y < y1-mainChar.pHeight/2) {
      mainChar.position.y = y2-mainChar.pHeight/2;
      groundCheck[platformNum] = true;
      mainChar.velocity.y = 0;
      mainChar.acceleration.y = 0;
    } else if (mainChar.position.y < y2-mainChar.pHeight/2) { 
      groundCheck[platformNum] = false;
      grounded = false;
    } 
    if (mainChar.position.x+mainChar.pHeight/2 < x1 || mainChar.position.x-mainChar.pHeight/2 > x2) {
      groundCheck[platformNum] = false;
      grounded = false;
    }
    //ceiling check, if player bumps his head on the bottom of the platform
    if (mainChar.position.y > y2-mainChar.pHeight/2 && mainChar.position.y < y1+mainChar.pHeight/2 && mainChar.position.x > x1 +20 - mainChar.pWidth/2 && mainChar.position.x < x2 -20 + mainChar.pWidth/2) {
      mainChar.velocity.y = 0;
      mainChar.position.y = y1+mainChar.pHeight/2;
      //slows you down if you bump your head
      mainChar.velocity.x *= 0.8;    
    }
  }

  void sideCollisionCheck() {
    //if the player touches the side of a platform, stops their movement
    if (mainChar.position.y-mainChar.pHeight/2<y1 && mainChar.position.y+mainChar.pHeight/2>y2 && mainChar.position.x+15 > x1 && mainChar.position.x-15 < x2) {
      mainChar.velocity.x = 0;
      mainChar.acceleration.x = 0;
      //slows your fall
      mainChar.velocity.y *= 0.8;
      if (abs(mainChar.position.x+mainChar.pWidth/2- x2) > abs(mainChar.position.x-mainChar.pWidth/2- x1)) {
        mainChar.position.x = x1 - mainChar.pWidth/2;
      } else {
        mainChar.position.x = x2 +mainChar.pWidth/2 ;
      }
    }
  }
}