///////////////////////////////
//////SUPER BOX SHOOTER////////
///////////////////////////////

//Oct 22nd 2016
//Intro to Media Computation
//Instructor: Nicolas Hesler
//Created by: William Lu

//WASD or ARROW KEYS to move. Hold SPACE to shoot. 
//Destroy as many boxes as you can! 
//Don't touch them!
//I know, the game isn't very balanced.

//Defining objects as each class
Player mainChar;
Platform base1;
Platform base2;
Platform middle;
Platform mid2;
Platform mid3;
Platform mid4;
Platform top;
Spawner spawner;
Enemy[] e;
Game_State gs;

Wall leftWall;
Wall rightWall;
Wall topw1;
Wall topw2;
Wall bot1;
Wall bot2;

//boolean to check if the main character is on the ground
boolean grounded;
int arrayN;
boolean[] groundCheck;

//player dead
boolean pDead;

ArrayList<Bullet> bullets;

//player movement
boolean playerRight;
boolean playerLeft;
boolean playerUp;
boolean playerShoot;

boolean facingRight = true;
boolean facingLeft = false;

//The last button held down by the user. 1 = right, 2 =left
int lastHeldButton = 1;
//# of enemies
int enemyNum = 1000;

float gravity;




void setup () {
  size (600, 400);
  frameRate(60);
  noStroke();
  //spawner = new Spawner();

  //defining the objects
  mainChar = new Player();
  base1 = new Platform(0, 400, 260, 380, 0);
  base2 = new Platform(340, 400, 600, 380, 1);
  middle = new Platform(150, 295, 450, 280, 2);
  mid2 = new Platform(0, 195, 200, 180, 3);
  mid3 = new Platform(400, 195, 600, 180, 4);
  mid4 = new Platform(250, 95, 350, 80, 5);
  top = new Platform(0, 20, 600, 0, 6);

  rightWall = new Wall( 580, 400, 600, 0);
  leftWall = new Wall( 0, 400, 20, 0);

  spawner = new Spawner();
  bullets = new ArrayList<Bullet>();
  e = new Enemy[enemyNum];
  gs = new Game_State();

  //assigns random constructor variables for enemies. random speed, and random paths. numbers each monster.
  for (int i = 0; i<enemyNum; i++) {
    e[i] = new Enemy( random( 0.8, 1.2), int(random(1, 5)), i);
  }



  facingRight = true;
  facingLeft = false;
  groundCheck = new boolean[10];
  arrayN = 0;
  grounded = false;
}

void draw () {
  background (255);

  if (bullets==null) {
    return;
  }

  bullets.add(new Bullet());

  //draws every bullet all at once
  for (int i=0; i<bullets.size(); i++) {
    Bullet bullet=bullets.get(i);
    bullet.update();
    bullet.hit();
    bullet.display();
  }

  //removes the first bullet from the array once max size is reached
  if (bullets.size() > 100) {
    bullets.remove(0);
  }



  top.display();
  top.collisionCheck();



  spawner.display();
  spawner.updateCounter();

  direction();
  mainChar.update();
  mainChar.display();
  updateGravity();

  base1.display();
  base1.collisionCheck();

  base2.display();
  base2.collisionCheck();

  middle.display();
  middle.collisionCheck();
  middle.sideCollisionCheck();

  mid2.display();
  mid2.collisionCheck();
  mid2.sideCollisionCheck();

  mid3.display();
  mid3.collisionCheck();
  mid3.sideCollisionCheck();

  mid4.display();
  mid4.collisionCheck();
  mid4.sideCollisionCheck();

  leftWall.display();
  leftWall.sideCollisionCheck();

  rightWall.display();
  rightWall.sideCollisionCheck();

  keyPresses();
  grounding();

  gs.playerDeath();
  gs.updateScore();


  //text used for debugging

  //fill (0);
  //text (mainChar.position.x + " " + mainChar.position.y, 100, 100);
  //text (mainChar.velocity.x + " " + mainChar.velocity.y, 100, 120);
  //text (mainChar.acceleration.x + " " + mainChar.acceleration.y, 100, 140);
  //println (grounded, facingRight, s.counter, e[0].hp, pDead, gs.score);
}

void keyPresses() {
  //key press visuals
  //up
  rectMode(CENTER);
  if (playerUp == true) {
    //slowly fades away over time
    fill(0, 175 - frameCount/3);
  } else { 
    fill ( 150, 175 - frameCount/3);
  }
  rect ( 250, 180, 15, 15);

  //space
  if (playerShoot == true) {
    fill(0, 175 - frameCount/3);
  } else { 
    fill ( 150, 175 - frameCount/3);
  }
  rect ( 335, 200, 90, 15);

  //left
  if (playerLeft == true) {
    fill(0, 175 - frameCount/3);
  } else { 
    fill ( 150, 175 - frameCount/3);
  }
  rect ( 230, 200, 15, 15);

  //right
  if (playerRight == true) {
    fill(0, 175 - frameCount/3);
  } else { 
    fill ( 150, 175 - frameCount/3);
  }
  rect ( 270, 200, 15, 15);

  //down

  fill ( 150, 175 - frameCount/3);
  rect ( 250, 200, 15, 15);
}


void updateGravity () {
  if (grounded == true) {
    //no gravity if player is on the ground. DONT do this in your own code, I approached this wrong. gravity should never change
    gravity = 0;
  } else { 
    gravity = 0.07;
  }
}


void grounding() {
  //Check every platform to see if a player is standing on any of them. if true, then grounded = true
  for (arrayN=0; arrayN < 9; arrayN = arrayN +1) {
    if (groundCheck[arrayN] == true) {
      grounded = true;
    } else if (groundCheck [arrayN] == false) {
    }
  }
  if (arrayN == 9) {
    arrayN = 0;
  }
}

void keyPressed() {
  if (key == 'a' || key == 'A' || keyCode == LEFT) {
    playerLeft = true;
    lastHeldButton = 2;
  } 
  if (key == 'd' || key == 'D' || keyCode == RIGHT) {
    playerRight = true;
    lastHeldButton = 1;
  } 
  if (key == 'w' || key == 'W' || keyCode == UP) {
    playerUp = true;
  } 
  if (key == ' ') {
    playerShoot = true;
  }
}

void keyReleased() {
  if (key == 'a' || key == 'A' || keyCode == LEFT) {
    playerLeft = false;
  } 
  if (key == 'd' || key == 'D' || keyCode == RIGHT) {
    playerRight = false;
  } 
  if (key == 'w'|| key == 'W' || keyCode == UP) {
    playerUp = false;
  } 
  if (key == ' ') {
    playerShoot = false;
  }
}

void mousePressed() {
  //if you die, and you click the mouse, all the variables are reset
  if (pDead == true) {
    mainChar = new Player();
    base1 = new Platform(0, 400, 260, 380, 0);
    base2 = new Platform(340, 400, 600, 380, 1);
    middle = new Platform(150, 295, 450, 280, 2);
    mid2 = new Platform(0, 195, 200, 180, 3);
    mid3 = new Platform(400, 195, 600, 180, 4);
    mid4 = new Platform(250, 95, 350, 80, 5);
    top = new Platform(0, 20, 600, 0, 6);

    rightWall = new Wall( 580, 400, 600, 0);
    leftWall = new Wall( 0, 400, 20, 0);

    spawner = new Spawner();

    bullets = new ArrayList<Bullet>();
    e = new Enemy[enemyNum];

    gs = new Game_State();
    for (int i = 0; i<enemyNum; i++) {
      e[i] = new Enemy( 1, int(random(1, 5)), i);
    }
    pDead = false;
  }
}


void direction() {
  //determines the direction you're facing based on your x axis acceleration
  if (mainChar.acceleration.x > 0) {
    facingRight = true;
    facingLeft = false;
  }
  if (mainChar.acceleration.x < 0) {
    facingLeft = true;
    facingRight = false;
  }
}