class Monster {

  PVector position=new PVector(50, 50); // Initialization. Make it into the while loop.
  PVector velocity=new PVector();


  float monsterColor;

  Monster() {
    init();
  }

  void init() {
    // set initial Monster values

    while ((position.x<width)&&(position.x>0)&&(position.y>0)&&(position.y<height)) // this is the best way to randomize the monsters and make sure it does not appear on the screen at first  
    { 
      position.x=random(-200, width+200);
      position.y=random(-200, height+200);
    }

    velocity.x=(tank.position.x-position.x)/125;//Velocity updated off the current tank position.
    velocity.y=(tank.position.y-position.y)/125;//make sure the monsters was chasing the tank from the beginning.
    monsterColor=random(255);
  }


  void update() {
    // move monster towards the tank
    position.add(velocity);
    // if monster has moved off sponing areas, re-initialize it
    if ((position.x<-200)||(position.x>width+200)||(position.y<-200)||(position.y>height+200)) {
      init();
    }
  }


  void display() {

    
    stroke(monsterColor);
    strokeWeight(1);
    fill(monsterColor);
    
    // tentacles 
    line(position.x-10, position.y-10, position.x+10, position.y+10);
    line(position.x-10, position.y+10, position.x+10, position.y-10);
    // face
    ellipse (position.x, position.y, 10, 10);
    // eyes
    fill(255-monsterColor);
    ellipse (position.x+2, position.y-2, 2, 2);
    ellipse (position.x-2, position.y-2, 2, 2);

    if (dist(position.x, position.y, tank.position.x, tank.position.y)<20) // check if it hit the core of the tank. yes: restart the game, clear the score, increment the death 
    {
      death++;
      
      setup();
    }
  }
}